package smart_gs.menu;

import javax.swing.JMenu;
import javax.swing.JMenuBar;

import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.EditorTextPane;
@SuppressWarnings("serial")
public class GSMenuBar extends JMenuBar{
	private EditMenu editMenu;
	private GSEditorTextPane textPane;
	
	//2007/11/1 kazuhiro kobayashi
	public GSMenuBar(AbstractGSWindow parent,GSEditorToolBar gsEditorToolBar){
		JMenu fileMenu = new FileMenu("File");
		this.add(fileMenu);
		this.editMenu = new EditMenu("Edit", this.textPane,gsEditorToolBar);
		this.add(editMenu);
		JMenu toolMenu = new ToolMenu("Tool", parent);		
		this.add(toolMenu);
		JMenu searchMenu = new SearchMenu("Search", parent);		
		this.add(searchMenu);
		JMenu reasoningWebMenu = new ReasoningWebMenu("RW", parent);
		this.add(reasoningWebMenu);
		JMenu lineSegmentMenu = new LineSegmentMenu("Line Segment", parent);		
		this.add(lineSegmentMenu);
		JMenu connectionMenu = new ConnectionMenu("Connection", parent);		
		this.add(connectionMenu);
		
		
		JMenu preferenceMenu = new PreferenceMenu("Preference", parent);		
		this.add(preferenceMenu);
//		JMenu sheetMenu = new SheetMenu("Sheet");
//		this.add(sheetMenu);
	}
	public void setEditorTextPane(EditorTextPane textPane){
		this.editMenu.setTextPane(textPane);
		this.validate();
	}
	
}
