package smart_gs.logical;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

import smart_gs.logical.SpreadSelectionList;

public class ShowSepradSelectionListsInTable extends JFrame {
	private ArrayList<SpreadSelectionList> selectionLists;

	public class TableRowSorterWithoutColumnClass extends JFrame {
		  public TableRowSorterWithoutColumnClass() {

		    String[] columns = { "Name", "Selection List!" };
		    
		    SpreadSelectionListManager sslManeger = SpreadSelectionListManager.getInstance();
		    ArrayList<SpreadSelectionList> sslLists = sslManeger.getSpreadSelectionLists();
		    int size = sslLists.size();
		    Object[][] rows = new String[size][2];
		    
		    for (int i = 0; i < size; i++) {
		    	rows[i][0] = (sslLists.get(i)).getName();
		    	rows[i][1] = (sslLists.get(i)).getSpreadSelectionListSpec();
		    }
		   
		    TableModel model = new DefaultTableModel(rows, columns);
		    JTable table = new JTable(model);
		    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		    RowSorter<TableModel> sorter = new TableRowSorter<TableModel>(model);
		    table.setRowSorter(sorter);
		   
		    TableColumn name_col, spec_col;
		    name_col = table.getColumnModel().getColumn(0);
		    spec_col = table.getColumnModel().getColumn(1);
		    name_col.setPreferredWidth(500);
		    spec_col.setPreferredWidth(600);
		    
		    getContentPane().add(new JScrollPane(table));

//		    this.setSize(60, 60);
		    this.setVisible(true);
		  }
	};

	public void showTable () {
		new TableRowSorterWithoutColumnClass();
	}
}