package smart_gs.logical;


import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import smart_gs.logical.visitor.Visitor;
import sml_editor.parser.SMLParser;



public abstract class IDAT extends SmartDocument{
	
	protected Spread spread;
	protected String leftSource;
	protected String rightSource;
//	2011.02.24 shayashi
	protected String nameToDisplay = null;
	
	public String getNameToDisplay() {
		return nameToDisplay;
	}
	public void setNameToDisplay(String nameToDisplay) {
		this.nameToDisplay = nameToDisplay;
	}
	
	public IDAT(String uri){
		super(uri);
	}
	public IDAT(Spread spread,String uri) {
		super(uri);
		this.spread = spread;
		
		this.leftSource = "<xml><left><html></html></left></xml>";
		this.rightSource = "<xml><right><html></html></right></xml>";
	}
	
	public Spread getSpread(){
		return this.spread;
	}
	@Override
	public String getSource() {
		/**
		 * @PleftSource + rightSourceԂ
		 * <xml>left̓e</xml><xml>right̓e</xml>ƂȂ
		 * \IɂȂ̂Œ
		 * 
		 * RXgN^܂߂āÂ̏C
		 * 
		 */
		int begin = leftSource.indexOf("<xml>")+"<xml>".length();
		int end = leftSource.indexOf("</xml>");
		String left = "";
		if(!(begin == -1 || end == -1) ){
			left = leftSource.substring(begin,end);
		}
	    
		begin = rightSource.indexOf("xml>")+"xml>".length();
		end = rightSource.indexOf("</xml>");
	    String right = "";
		if(!(begin == -1 || end == -1) ){
			right = rightSource.substring(begin,end);
		}
		this.source =  "<xml>"+left+right+"</xml>";
		return this.source;
	}
	public String getLeftPageSource(){
		return this.leftSource;
	}
	public String getRightPageSource(){
		return this.rightSource;
	}

	public void setLeftSource(String source){
		this.leftSource = source;
	}
	public void setRightSource(String source){
		this.rightSource = source;
	}
	public abstract int getType();
	

	public GSResource getTextSegmentByURI(String uri) {
		for(int i=0;i<this.segments.size();i++){
			if(this.segments.get(i).uri.equals(uri)){
				return this.segments.get(i);
			}
		}
		return null;
	}
	public void setSpread(Spread spread) {
		this.spread = spread;
		this.confirmSegments();
	}
	private void confirmSegments(){
		Document doc;
		try {
			doc = SMLParser.parse(this.source);
			this.checkSegments(doc.getDocumentElement());
		} catch (SAXException e) {
			e.printStackTrace();
		}
	}
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	public abstract String getExtension();
}
