package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class BookmarkView extends View {
	private static Color BOOKMARK_COLOR = new Color(255,0,0,128);
	public static double WIDTH = 100;
	public static double HEIGHT = 30;
	
	private Rectangle2D rectangle;
	private String title;
	
	public BookmarkView(Rectangle2D rectangle, String title) {
		this.rectangle = rectangle;
		this.title = title;
	}

	@Override
	public boolean contains(Point2D point) {
		return this.rectangle.contains(point);
	}

	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("view");
		element.setAttribute("type","bookmark");
		element.setAttribute("x",this.rectangle.getX()+"");
		element.setAttribute("y",this.rectangle.getY()+"");
		element.setAttribute("title",this.title);
		return element;
	}
	public static View restore(Element elem) {
		double x = new Double(elem.getAttribute("x"));
		double y = new Double(elem.getAttribute("y"));
		String title = elem.getAttribute("title");
		BookmarkView view = new BookmarkView(new Rectangle2D.Double(x, y, WIDTH, HEIGHT), title);
		return view;
	}

	@Override
	public void drawLinkedShape(Graphics2D g) {
		drawShape(g);
	}

	@Override
	protected void drawShape(Graphics2D g) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double w = this.rectangle.getWidth();
		double h = this.rectangle.getHeight();
		g.setColor(BOOKMARK_COLOR);
		g.fill(this.rectangle);
		g.setColor(Color.BLACK);
		if (this.isSelected) {
			g.setStroke(new BasicStroke(2));
		}
		g.draw(new Rectangle2D.Double(x-1, y-1, w, h));
		if (this.isProtected) {
			double px = x - 4;
			double py = y - 4;
			double pw = w + 6;
			double ph = h + 6;
			g.setStroke(new BasicStroke(1));
			g.draw(new Rectangle2D.Double(px, py, pw, ph));
		}
	}

	@Override
	public BookmarkView enlargedView(double ratio, double gapX, double gapY) {
		double x = this.rectangle.getX() * ratio + gapX;
		double y = this.rectangle.getY() * ratio + gapY;
		double w = this.rectangle.getWidth() * ratio;
		double h = this.rectangle.getHeight() * ratio;
		Rectangle2D newrect = new Rectangle2D.Double(x, y, w, h);
		BookmarkView view = new BookmarkView(newrect, this.title);
		view.setIsSelected(this.isSelected);
		view.isProtected = this.isProtected;
		return view;
	}

	@Override
	public Point getCenterPoint() {
		return new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
	}

	@Override
	public Rectangle2D getRectangle2D() {
		return this.rectangle;
	}

	@Override
	public int getType() {
		return View.BOOKMARK;
	}

	@Override
	public String getTypeString() {
		return "bookmark";
	}

	@Override
	public void moveBy(Point2D d) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double w = this.rectangle.getWidth();
		double h = this.rectangle.getHeight();
		this.rectangle = new Rectangle2D.Double(x+d.getX(),y+d.getY(), w, h);
	}

	public String getTitle() {
		return this.title;
	}
}
