package smart_gs.drawing_tool.drawing_mode;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.region.MemoPadRegion;
import smart_gs.swingui.GSMouseEvent;

public class MemoPadMode extends DrawingModeAdapter{

	private static Mode singleton = new MemoPadMode();
	
	private Point2D start;
	private Point2D end;
	
	public static Mode getInstance() {
		return singleton;
	}

	@Override
	public void mousePressed(GSMouseEvent e, SpreadCanvas canvas) {
		super.mousePressed(e, canvas);
		this.start = e.getPoint();
	}
	@Override
	public void mouseDragged(GSMouseEvent e,SpreadCanvas canvas) {
		super.mouseDragged(e,canvas);
		this.end = e.getPoint();
	}
	
	@Override
	public void mouseReleased(GSMouseEvent e, SpreadCanvas canvas) {
		super.mouseReleased(e, canvas);
		if(start == null || end == null){
			return ;
		}		
		canvas.addRegion(new MemoPadRegion(canvas.getSpread(), adjustRect(start.getX(), start.getY())));
		this.start = null;
		this.end = null;
	}
	@Override
	public void paint(Graphics g,SpreadCanvas canvas) {
		super.paint(g,canvas);
		if(this.start == null || this.end == null){
			return;
		}
		double ratio = canvas.getImageLabel().getRatio();
		double gapX = canvas.getImageLabel().getGapWidth();
		double gapY = canvas.getImageLabel().getGapHeight();
		MemoPadView view = new MemoPadView(adjustRect(start.getX(), start.getY()), MemoPadView.defaultMemoPadText).enlargedView(ratio, gapX, gapY);
//		view.setMemoPadText("MemoPad"); // debug
		view.draw((Graphics2D)g);
		
	}
	private Rectangle2D.Double adjustRect(double sx, double sy){
		double width, height;
		double startX, startY;
		
		if(start.getX() > end.getX()){
			startX = end.getX();
			width = start.getX() - end.getX();
		}
		else{
			startX = start.getX();
			width = end.getX() - start.getX();
		}
		if(start.getY() > end.getY()){
			startY = end.getY();
			height = start.getY() - end.getY();
		}
		else{
			startY = start.getY();
			height= end.getY() - start.getY();
		}
		return new Rectangle2D.Double(startX,startY,width,height);
	}
}
