package smart_gs.drawing_tool.action;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.util.List;

import javax.swing.JOptionPane;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.Region;

public class NextRegionAction implements ActionListener {
	private Region region;
	private SpreadCanvas canvas;
	private State state;
	
	public NextRegionAction(Region region, SpreadCanvas canvas, State state) {
		this.region = region;
		this.canvas = canvas;
		this.state = state;
	}
	public void actionPerformed(ActionEvent e) {
		List<Region> regions = canvas.getCurrentSpread().getRegions();
		regions.get(regions.size()-1).getView().setIsSelected(false);
		for (int i = 0; i < regions.size(); i++) {
			if (regions.get(i).getView().getType() == this.region.getView().getType()) {
				((UniSelectedState)state).setSelectedRegion(regions.get(i));
				regions.add(regions.remove(i));
				canvas.setSelectedNumberOfRegion(regions.size()-1);
				regions.get(regions.size()-1).getView().setIsSelected(true);
				Point point = regions.get(regions.size()-1).getView().getCenterPoint();
				canvas.getImageLabel().scrollTo(point);
				return;
			}
		}
	}
	public void actionPerformed(KeyEvent e) {
		List<Region> regions = canvas.getCurrentSpread().getRegions();
		regions.get(regions.size()-1).getView().setIsSelected(false);
		for (int i = 0; i < regions.size(); i++) {
			if (regions.get(i).getView().getType() == this.region.getView().getType()) {
				((UniSelectedState)state).setSelectedRegion(regions.get(i));
				regions.add(regions.remove(i));
				canvas.setSelectedNumberOfRegion(regions.size()-1);
				regions.get(regions.size()-1).getView().setIsSelected(true);
				Point point = regions.get(regions.size()-1).getView().getCenterPoint();
				canvas.getImageLabel().scrollTo(point);
				return;
			}
		}
	}


}
