package smart_gs.drawing_tool.action;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.text.SimpleAttributeSet;

import smart_gs.connection.ConnectionCreator;
import smart_gs.logical.Preference;
import smart_gs.reasoning_web.logical.GS_RWElement;
import sml_editor.swingui.EditorTextPane;

public class JumpWebPageAction implements ActionListener {
	
	private EditorTextPane textPane;
	private Point point;
	
	public JumpWebPageAction(EditorTextPane textPane,Point point){
		this.textPane = textPane;
		this.point = point;
	}
	
	public void actionPerformed(ActionEvent e) {
		String url = textPane.getSelectIDStr(point);
		String browser = Preference.getInstance().getInstance().getBrowser();
		if(browser == null){
			JOptionPane.showMessageDialog(
					new JFrame() , "Please set web browser." , "fatal" ,
					JOptionPane.ERROR_MESSAGE
				);
			return;
		}
		try{
			Runtime.getRuntime().exec(new String[] {browser, url});
		}catch(Exception ex){
			JOptionPane.showMessageDialog(
					new JFrame() , "Please set web browser." , "fatal" ,
					JOptionPane.ERROR_MESSAGE
				);

		}
	}

}
