package smart_gs.drawing_tool.action;


import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;
import javax.swing.JFrame;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.State;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.Region;

public class DeleteRegionAction{
	
	private List<Region> regions;
	private State state;
	
	private DeleteRegionAction(){
		this.regions = new ArrayList<Region>();
	}
	public DeleteRegionAction(Region region){
		this();
		this.regions.add(region);
	}
	public DeleteRegionAction(Region region, State state){
		this();
		this.regions.add(region);
		this.state = state;
	}
	public DeleteRegionAction(List<Region> regions){
		this();
		this.regions = regions;
	}
	public void execute(){
		if(regions.get(0) != null){
			for(int i=0;i<this.regions.size();i++){
				if(regions.get(i).isProtected().equals(Region.NORMAL)){
					this.regions.get(i).getSpread().removeRegion(this.regions.get(i));
					//((UniSelectedState) state).setSelectedRegion(null);
					State state = DefaultState.getInstance();
				    ImageLabel.setState(state);
				}
				else{
					JOptionPane.showMessageDialog(new JFrame(), "this region is protected","cant't delete",  JOptionPane.INFORMATION_MESSAGE);
				}
			}
			this.regions.clear();
		}
	}
	
}
