package image_editor;

import image_editor.toolbar.ImageEditorToolBar;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import smart_gs.image_search.normal.swingui.ImageSearchPanel;
//kazuhiro kobayashi 10/2
import image_editor.toolbar.AdjustLinePanel;

@SuppressWarnings("serial")

public class QueryImageEditor extends JDialog{
	
	private EditorCanvas canvasLabel;
	private Image image;
	private JPanel canvasPanel;
	//kazuhiro kobayashi 10/2
	private AdjustLinePanel adjustPanel;
	
	private boolean isEdited = false;
	
	public QueryImageEditor(Dialog parent,Image image,int width,int height) {
		super(parent,"Image Editor",true);
		this.image = image;
		canvasPanel = new JPanel();
		this.canvasLabel = new EditorCanvas(image,width,height);
		canvasPanel.add(this.canvasLabel);
		this.getContentPane().setLayout(new BorderLayout());
		JToolBar toolbar = new ImageEditorToolBar(this.canvasLabel);
		
		//kazuhiro kobayashi 10/2
		this.adjustPanel = new AdjustLinePanel();
		
		JPanel buttonPanel = new JPanel();
		JButton okButton = new JButton("OK");
		okButton.addActionListener(new OKAction());
		JButton cancelButton = new JButton("Cancel");
		cancelButton.addActionListener(new CancelAction());
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		
		this.getContentPane().add(toolbar,BorderLayout.NORTH);
		this.getContentPane().add(canvasPanel,BorderLayout.CENTER);
		
		//kazuhiro kobayashi 10/2
		this.getContentPane().add(adjustPanel, BorderLayout.EAST);
		
		this.getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		this.setLocation(parent.getLocationOnScreen());
		this.pack();
	}
	
	public QueryImageEditor(ImageSearchPanel imageSearchPanel, Image image2,
			int width, int height) {
		// TODO Auto-generated constructor stub
	}

	public Image getImage() {
		return this.image;
	}
	public boolean isEdited(){
		return this.isEdited;
	}
	private class OKAction implements ActionListener{
		
		public void actionPerformed(ActionEvent arg0) {
			image = canvasLabel.getImage();
			isEdited = true;
			setVisible(false);
		}
	}
	
	private class CancelAction implements ActionListener{
		
		public void actionPerformed(ActionEvent arg0) {
			dispose();
		}
	}
}
