package image_editor;

import java.awt.Color;
import java.awt.event.MouseEvent;
import image_editor.toolbar.DrawPolygonCommand;

public class PolygonMode extends Mode {

	private int lastX, lastY;
	private int currentX, currentY;
	
	private static float WIDTH;
//	private static int DEPTH;

	static Mode singleton = new PolygonMode();

	public static Mode getInstance() {
		return singleton;
	}

	public static void setWidth(float width){
		WIDTH = width;
	}
//	public static void setColorDepth(int depth){
//		DEPTH = depth;
//	}
	
	@Override
	public void mouseClicked(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub
		if (e.getButton() == MouseEvent.BUTTON1) {
			
			currentX = e.getX();
			currentY = e.getY();
			lastX = e.getX();
			lastY = e.getY();
		}
	}

	@Override
	public void mouseDragged(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub
		currentX = e.getX();
		currentY = e.getY();
		DrawPolygonCommand polygon = new DrawPolygonCommand(lastX, lastY, currentX,
				currentY);
		polygon.setWidth(WIDTH);
//		polygon.changeColorDepth(DEPTH);
		canvas.addCommand(polygon);
		lastX = currentX;
		lastY = currentY;

	}

	@Override
	public void mouseEntered(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void mouseExited(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void mouseMoved(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

	@Override
	public void mousePressed(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub
		currentX = e.getX();
		currentY = e.getY();
		lastX = e.getX();
		lastY = e.getY();

	}

	@Override
	public void mouseReleased(MouseEvent e, EditorCanvas canvas) {
		// TODO Auto-generated method stub

	}

}
