package smart_gs.logical;

import java.awt.BorderLayout;
import java.awt.Image;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.logical.visitor.Visitor;

public class Zombie extends GSResource implements RWElement {

	String deadURI;
	
	public Zombie(String deadURI) {
		super();
		this.deadURI = deadURI;
		this.createURI();
	}
	
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}

	@Override
	public String getSource() throws NotMarkupException {
		return null;
	}

	@Override
	public String getTypeString() {
		return URIObject.ZOMBIE;
	}

	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
	
	public String getDeadURI() {
		return this.deadURI;
	}
	public void setDeadURI(String deadURI) {
		this.deadURI = deadURI;
	}

	public JPanel createElementViewPanelForLocalView() {
		Image image=null;
		try {
			image = ImageIO.read(new File("./icons/zombie.png"));
		} catch (IOException e) {
			System.out.println("Failed to generate error message image! In Zombie.java");
		}
		
		JLabel label = new JLabel();
		label.setHorizontalAlignment(JLabel.CENTER);
		ImageIcon icon = new ImageIcon(image);
		label.setIcon(icon);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add(label,BorderLayout.CENTER);
		return panel;
	}
}