/* $Id: SmlNode.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 쐬F 2004/10/12
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package sml_editor.node;

import org.w3c.dom.Node;

/**
 * @author kawamura
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public interface SmlNode {
    /**
     * The node is an <code>Element</code>.
     */
    public static final short ELEMENT_NODE              = 1;
    /**
     * The node is an <code>Attr</code>.
     */
    public static final short ATTRIBUTE_NODE            = 2;
    /**
     * The node is a <code>Text</code> node.
     */
    public static final short TEXT_NODE                 = 3;
    /**
     * The node is a <code>CDATASection</code>.
     */
    public static final short COMMENT_NODE              = 8;
    /**
     * The node is a <code>Document</code>.
     */
    public static final short DOCUMENT_NODE             = 9;
    /**
     * The node is a <code>BR</code>
     */
    public static final short BR_NODE                   = 13;

    
	public Node getNode();
	public int getLength();

	public SmlNode getParentNode();
	public void setParentNode(SmlElement parent);

	public SmlNode appendChild(SmlNode newChild);
	public SmlNode removeChild(SmlNode oldChild);
	public SmlNode replaceChild(SmlNode newChild, SmlNode oldChild);
	public SmlNode insertBefore(SmlNode newChild, SmlNode refChild);
	
	public SmlNode getFirstChild();
	public SmlNode getLastChild();

	public SmlNode getNextSibling();
	public SmlNode getPreviousSibling();

	public String getNodeName();
	public short getNodeType();

	public boolean hasAttributes();
	
	public void setNodeValue(String nodeValue);
	public String getNodeValue();
	
	/**
	 * anotherNode ̃m[h̏ʃm[hłꍇAtrue ԂB
	 * this == anotherNodȅꍇtrueԂB
	 * @param anotherNode - ̃m[h̏ʃm[hǂ𒲂ׂm[h
	 * @return ̃m[h anotherNode ̉ʃm[hłꍇ true
	 */
	public boolean isNodeAncestor(SmlNode anotherNode);
	
	/**
	 * ̃m[h anotherNode ɂƂ߂ʂ̏ʃm[hԂB
	 * ̏ʃm[h̏ꍇ͏ʂłق̃m[hԂB
	 * @param anotherNode - ʂ̏ʃm[hm[h
	 * @return ̃m[h anotherNode ɂƂ߂ʂ̏ʃm[hB
	 * Ȃꍇ null
	 */
	public SmlNode getSharedAncestor(SmlNode anotherNode);
	
	/**
	 * [g炱̃m[h܂ł̐[ԂB
	 * @return [g̐[
	 */
	public int getLevel();

	/**
	 * ̃m[h root element 肷
	 * @return ̃m[h root Ȃ true
	 */
	public boolean isRootElement();
	
	/**
	 * root element炱̃m[h܂ł̃pXԂBႦ΂̃m[h
	 * root element2Ԗڂ̎q4Ԗڂ̎q3Ԗڂ̎qłꍇA
	 * ߂l "/2/4/3" ƂStringɂȂB
	 * @return
	 */
	public String getPathFromRootElement();
	
}
