/* $Id: SpreadSelectionTreeDirectoryPopupMenu.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.spread_selection;

import javax.swing.JPopupMenu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import smart_gs.drawing_tool.action.SheetSelectAction;
import smart_gs.logical.Spread;
import smart_gs.logical.Sheet;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.toolbar.action.HTMLFileFilter;
import smart_gs.swingui.toolbar.action.TextFileFilter;
import smart_gs.util.StringUtils;

public class SpreadSelectionTreeDirectoryPopupMenu extends JPopupMenu {

	private JMenuItem setSheetNameItem;
	private JMenuItem showSheetItem;
	private DefaultMutableTreeNode directory;
	private Enumeration<DefaultMutableTreeNode> enm;
	private SpreadSelectionTree tree;

	public SpreadSelectionTreeDirectoryPopupMenu(SpreadSelectionTree givenTree, DefaultMutableTreeNode givenNode){

		tree = givenTree;
		
		if(givenNode != null){
			directory = givenNode;
			JMenuItem checkAll = new JMenuItem("Check all in directory");
			checkAll.addActionListener(new CheckAllSpreadsAction(directory));
			this.add(checkAll);
			JMenuItem uncheckAll = new JMenuItem("Uncheck all in directory");
			uncheckAll.addActionListener(new UnckeckAllSpreadAction(directory));
			this.add(uncheckAll);			
		};
		
		enm = directory.depthFirstEnumeration();
	}

	class CheckAllSpreadsAction implements ActionListener {

		public CheckAllSpreadsAction(DefaultMutableTreeNode directory) {
		}

//		@Override
		public void actionPerformed(ActionEvent arg0) {
			while (enm.hasMoreElements()) {
				Object obj = enm.nextElement().getUserObject();
				if ( obj instanceof CheckBoxNode ) {
					((CheckBoxNode) obj).setSelected(true);
				}
			}
			tree.repaint();
		}

	}

	class UnckeckAllSpreadAction implements ActionListener {


		public UnckeckAllSpreadAction(DefaultMutableTreeNode directory) {
			// TODO Auto-generated method stub
		}

//		@Override
		public void actionPerformed(ActionEvent e) {
			while (enm.hasMoreElements()) {
				Object obj = enm.nextElement().getUserObject();
				if ( obj instanceof CheckBoxNode ) {
					((CheckBoxNode) obj).setSelected(false);
				}
			}
			tree.repaint();
		}

	}
}