package smart_gs.swingui.toolbar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

import smart_gs.GSConstants;
import smart_gs.drawing_tool.action.DeleteRegionAction;
import smart_gs.drawing_tool.drawing_mode.DefaultDrawingMode;
import smart_gs.drawing_tool.drawing_mode.FreeLineMode;
import smart_gs.drawing_tool.drawing_mode.MarkerMode;
import smart_gs.drawing_tool.drawing_mode.MemoPadMode;
import smart_gs.drawing_tool.drawing_mode.RectangleMode;
import smart_gs.drawing_tool.state.DefaultState;
import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.logical.Region;
import smart_gs.logical.Sheet;
import smart_gs.swingui.AbstractGSWindow;

@SuppressWarnings("serial")
public class ImageToolBar extends JToolBar implements ActionListener{
	
	private JButton select;
	private JButton eraser;

	private static JComboBox modelist;
	public static String[] modelistarray = { "<none>", "Rectangle", "Marker", "Lasso", "MemoPad" };
	public static int modeNone = 0;
	public static int modeRectangle = 1;
	public static int modeMarker = 2;
	public static int modeLasso = 3;
	public static int modeMemoPad = 4;
	
	private JButton zoomIn;
	private JButton zoomOut;
	
//	private JButton hideRegion;
	private static JComboBox showRegion;
	public static String[] showregionarray = { "All Regions", "Protected Regions", "No Regions" };
	public static int showAll = 0;
	public static int showProtected = 1;
	public static int showNo = 2;
	
//	private JButton changeSheet;
	
	private AbstractGSWindow parent;

	
	public ImageToolBar(AbstractGSWindow parent){
		this.parent = parent;
		
		this.select = new JButton(new ImageIcon(GSConstants.ICON_PATH+"select.gif"));
		this.select.addActionListener(this);
		this.select.setToolTipText("Select");
		this.add(this.select);
		
		this.eraser = new JButton(new ImageIcon(GSConstants.ICON_PATH+"delete.gif"));
		this.eraser.addActionListener(this);
		this.eraser.setToolTipText("Delete Region");
		this.add(this.eraser);

		modelist = new JComboBox(modelistarray);
		modelist.addActionListener(this);
		modelist.setToolTipText("Select Drawing Mode");
		this.add(modelist);
		
		this.zoomIn = new JButton(new ImageIcon(GSConstants.ICON_PATH+"zoom_in.gif"));
		this.zoomIn.addActionListener(this);
		this.zoomIn.setToolTipText("Zoom in");
		this.add(this.zoomIn);
		
		this.zoomOut = new JButton(new ImageIcon(GSConstants.ICON_PATH+"zoom_out.gif"));
		this.zoomOut.addActionListener(this);
		this.zoomOut.setToolTipText("Zoom out");
		this.add(this.zoomOut);
		/*
		 * 2007/9/11
		 */
//		this.hideRegion = new JButton("hideRegion");
//		this.hideRegion.addActionListener(this);
//		this.add(this.hideRegion);
		
		showRegion = new JComboBox(showregionarray);
		showRegion.addActionListener(this);
		showRegion.setToolTipText("Select the type of Regions to show");
		this.add(showRegion);
//		
//		this.changeSheet = new JButton("Sheet");
//		this.changeSheet.addActionListener(this);
//		this.add(this.changeSheet);
	}

	public void actionPerformed(ActionEvent e) {
		if(e.getSource().equals(this.select)){
			DefaultState.getInstance().setMode(DefaultDrawingMode.getInstance());
			setModeListItem(modelistarray[modeNone]);
		}else if(e.getSource().equals(modelist)){
			String mode = (String) ((JComboBox) e.getSource()).getSelectedItem();
			if(mode == modelistarray[modeRectangle]) {
				DefaultState.getInstance().setMode(RectangleMode.getInstance());
			} else if(mode == modelistarray[modeMarker]) {
				DefaultState.getInstance().setMode(MarkerMode.getInstance());
			} else if(mode == modelistarray[modeLasso]) {
				DefaultState.getInstance().setMode(FreeLineMode.getInstance());
			} else if(mode == modelistarray[modeMemoPad]) {
				DefaultState.getInstance().setMode(MemoPadMode.getInstance());
			}
		}else if(e.getSource().equals(this.zoomIn)){
			parent.getSpreadCanvas().zoomIn();
		}else if(e.getSource().equals(this.zoomOut)){
			parent.getSpreadCanvas().zoomOut();
		}else if(e.getSource().equals(this.eraser)){
			Region region = UniSelectedState.getInstance().getSelectedRegion();
			new DeleteRegionAction(region).execute();
//			DefaultState.getInstance().setMode(EraserMode.getInstance());
			
			parent.repaint();
		}else if(e.getSource().equals(showRegion)){
			String showRegionMode = (String) ((JComboBox) e.getSource()).getSelectedItem();
			if(showRegionMode == showregionarray[showAll]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_ALL_REGIONS);
			} else if(showRegionMode == showregionarray[showProtected]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_PROTECTED_REGIONS);
			} else if(showRegionMode == showregionarray[showNo]) {
				parent.getSpreadCanvas().getSpread().changeShowRegion(Sheet.SHOW_NO_REGIONS);
			}
			parent.repaint();
		}
	}

	public static void setModeListItem(String string) {
		modelist.setSelectedItem(string);
	}
	
	public static void setShowRegionItem(String string) {
		showRegion.setSelectedItem(string);
	}
	
}
