package image_search;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;

import smart_gs.util.ImageCropper;

public class Query {
	
	protected File dscFile;         
	protected Rectangle rectangle;  
	protected Image queryImage;
	protected Image image;
	
	public Query(Image image,File dscFile,Rectangle rectangle){
		this.dscFile = dscFile;
		this.rectangle = rectangle;
		this.image = image;
		this.queryImage = new ImageCropper(this.image,rectangle).crop();

	}
	public Image getQueryImage(){
		return this.queryImage;
	}
	public File getDSCFile(){
		return this.dscFile;
	}
	public Rectangle getRectangle(){
		return this.rectangle;
	}
	public void setRectangle(Rectangle rectangle){
		this.rectangle = rectangle;
		this.queryImage = new ImageCropper(this.image,rectangle).crop();
	}
}
