package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.logical.Spread;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.util.DSCFileMaker;

public class DscCompileAction implements ActionListener {
	
	private AbstractGSWindow gsWindow;
	private Spread spread;
	public DscCompileAction(AbstractGSWindow gsWindow){
		this.gsWindow = gsWindow;
	}
	public DscCompileAction(Spread spread){
		this.spread = spread;
	}
	public void dscCompile(){
		String folderPath = Spread.DSC_FOLDER_PATH+spread.getSpreadDirParent().getPath();
		String filename = spread.getFileNameWithoutExtension();
		String filetype = spread.getFileNameExtension();
		new DSCFileMaker(spread).dscCompile(folderPath, filename, filetype);
	}
	public void actionPerformed(ActionEvent e) {
		this.spread = this.gsWindow.getSpread();
		this.dscCompile();
	}
}
