/* $Id: ConnectonViewPanel.java 373 2011-10-01 16:30:41Z shayashi $ */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

import smart_gs.drawing_tool.ImageLabel;
import smart_gs.reasoning_web.logical.GS_RWRepository;

@SuppressWarnings("serial")
public class ConnectonViewPanel extends JPanel {

	private JScrollPane elementViewPanel;
	private ElementsPanel elementsPanel;
	private JScrollPane scrollPane;
	private JToolBar toolBar;

	

	public ConnectonViewPanel() {
		this.toolBar = new RWToolbar();
		this.elementViewPanel = new JScrollPane();
		this.elementsPanel = new ElementsPanel();
		// elementspanelGrobalViewPanel̊Ԃelement֘AtB
		GS_RWRepository.getInstance().addObserver(this.elementsPanel);

		this.elementViewPanel.setViewportView(elementsPanel);

		// Pane,Panel̍\
		JScrollPane leftMarkupsListPane = new JScrollPane(this.elementViewPanel);
		this.scrollPane = new JScrollPane();
		this.scrollPane
				.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		this.scrollPane
				.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		this.scrollPane.getVerticalScrollBar().setUnitIncrement(25);
		this.scrollPane.setViewportView(GlobalViewPanel.getInstance());
		
		
		JPanel mPanel = new JPanel(new BorderLayout());
		mPanel.add(this.scrollPane, BorderLayout.CENTER);
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
				true, leftMarkupsListPane, mPanel);
		splitPane.setOneTouchExpandable(true);
		splitPane.setDividerLocation(200);

		this.setLayout(new BorderLayout());
		this.add(splitPane, BorderLayout.CENTER);

	}

	/*
	 * ȉ̃\bhReasoningWebFrameĂяo
	 */
	public JToolBar getToolBar() {
		return this.toolBar;
	}

	public ElementsPanel getElementsPanel() {

		return elementsPanel;
	}

	public void reload() {
		this.elementsPanel.reload();
	}

}
