/* $Id: BucketPanel.java 389 2011-10-09 23:57:04Z minao $ */
package smart_gs.image_search.normal.swingui;

import java.awt.Color;
import java.awt.GridLayout;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBucket;

@SuppressWarnings("serial")
public class BucketPanel extends JPanel implements Observer{
	
	private QueryBucket bucket;
	private JFrame parent;
	
	public BucketPanel(JFrame parent,QueryBucket bucket){
		this.parent = parent;
		this.bucket = bucket;
		this.bucket.addObserver(this);
		this.updateGUI();
	}
	
	public void updateGUI(){
		this.removeAll();
		this.setLayout(new GridLayout(this.bucket.size(),1));
		for(int i=0;i<this.bucket.size();i++){
			GSQuery query = this.bucket.get(i);
//			TODO This is strange! Refactor it.
			JLabel label;
			if (i==0) {
				label = new JLabel(new ImageIcon(query.getQueryImageWithTransformation()));
			} else {
				label = new JLabel(new ImageIcon(query.getQueryImage()));
			}
			label.addMouseListener(new ShowQueryAction(query));
			JPanel panel = new JPanel();
			panel.setBorder(new LineBorder(Color.BLACK));
			panel.add(label);
//			JButton editButton = new JButton("edit");
//			editButton.addActionListener(new EditAction(this,query));
//			panel.add(editButton);
			//commented out by kukita 2011/10/8
			
			this.add(panel);
		}
		this.parent.validate();
		this.parent.toFront();
		this.parent.pack();
	}

	public void update() {
		this.updateGUI();
		
	}
	public QueryBucket getBucket() {
		return this.bucket;
	}
}
