/* $Id: ProxySetting.java 182 2011-05-26 20:15:53Z minao $ */
package webdav.preference;

import java.awt.BorderLayout;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.JLabel;
import java.awt.Rectangle;
import javax.swing.JTextField;
import javax.swing.JButton;

import smart_gs.logical.Preference;
import webdav.WebDavProcessor;

public class ProxySetting extends JDialog {

	private static final long serialVersionUID = 1L;

	private JPanel jContentPane = null;

	private JTextField address = null;

	private JLabel jLabel = null;

	private JLabel jLabel1 = null;

	private JTextField port = null;

	private JButton jButton = null;

	private JButton jButton1 = null;

	private JDialog myJDialog;
	/**
	 * This is the default constructor
	 */
	public ProxySetting(Frame frame,boolean modal) {
		super(frame,modal);
		initialize();
		myJDialog = this;
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(414, 178);
		this.setContentPane(getJContentPane());
		this.setTitle("Proxy Setting");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jLabel1 = new JLabel();
			jLabel1.setBounds(new Rectangle(25, 60, 85, 20));
			jLabel1.setText("Port");
			jLabel = new JLabel();
			jLabel.setBounds(new Rectangle(25, 30, 85, 20));
			jLabel.setText("Address");
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getServerpth(), null);
			jContentPane.add(jLabel, null);
			jContentPane.add(jLabel1, null);
			jContentPane.add(getPort(), null);
			jContentPane.add(getJButton(), null);
			jContentPane.add(getJButton1(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes serverpth	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getServerpth() {
		if (address == null) {
			address = new JTextField();
			Preference preference = Preference.getInstance().getInstance();
			if(preference.getProxyAddress() != null){
				address.setText(preference.getProxyAddress());
			}
			address.setBounds(new Rectangle(115, 30, 280, 22));
		}
		return address;
	}

	/**
	 * This method initializes userName	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getPort() {
		if (port == null) {
			port = new JTextField();
			port.setBounds(new Rectangle(115, 60, 100, 22));
			Preference preference = Preference.getInstance().getInstance();
			if(preference.getProxyPort() != null){
				port.setText(preference.getProxyPort());
			}
		}
		return port;
	}


	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton() {
		if (jButton == null) {
			jButton = new JButton();
			jButton.setBounds(new Rectangle(70, 95, 80, 30));
			jButton.setText("OK");
			jButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					String addressStr  = address.getText();
					String portStr = port.getText();
					if(!portStr.equals("")){
						try{
							Integer.parseInt(portStr);
						}catch(NumberFormatException ex){
							JOptionPane.showMessageDialog(
									new JFrame() , "The port number is not a figure." , "fatal" ,
									JOptionPane.ERROR_MESSAGE
								);
							return;
						}
					}
					Preference preference = Preference.getInstance().getInstance();
					preference.setProxyAddress(addressStr);
					preference.setProxyPort(portStr);
					preference.save();
					WebDavProcessor webDavProcessor = WebDavProcessor.getInstance(true);
					if(webDavProcessor == null){
						JOptionPane.showMessageDialog(
								new JFrame() , "It failed in login to WebDAV." , "fatal" ,
								JOptionPane.ERROR_MESSAGE
							);
						return;
					}
					myJDialog.setVisible(false);
				}
			});
		}
		return jButton;
	}

	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButton1() {
		if (jButton1 == null) {
			jButton1 = new JButton();
			jButton1.setBounds(new Rectangle(160, 95, 80, 30));
			jButton1.setText("Cancel");
			jButton1.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					myJDialog.setVisible(false);
				}
			});
		}
		return jButton1;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
