/* $Id: SegmentInfoCreator.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.util;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import smart_gs.image_search.logical.TextType;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Spread;
public class SegmentInfoCreator {
	
	private Spread spread;
	
	public SegmentInfoCreator(Spread spread){
		this.spread = spread;
	}
	public SegmentInfoCreator(){
		
	}
	public void createAllFile(String folderPath,String filename){
		File dscFolder = new File(Spread.DSC_FOLDER_PATH);
		
		if(!dscFolder.exists()){
			dscFolder.mkdir();
		}
		
		File folder = new File(folderPath);
		if(!folder.exists()){
			folder.mkdir();
		}
		
		//new BmpFileCreator(this.spread).create(folderPath, filename+".bmp",false); 20101030 shimizu wrote
		
		List<LineSegment> segments = spread.getLines();
		if(segments == null){
			return;
		}
		this.createSegmentInfo(segments, folderPath, filename);

		File file = new File(folderPath+filename+".xml");
		String absolutePath = file.getAbsolutePath();
		this.createDSCFile(absolutePath,true);
	}
	public void createSegmentInfo(List<LineSegment> segments,String folderPath,String filename){
		DocumentBuilder builder = null;
		Element segmentElement = null;
		Document document = null;
		if(segments == null){
			return;
		}
		try {
			builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			document = builder.newDocument();
			Element segmentInfoElement = document.createElement("segmentInfo");
			document.appendChild(segmentInfoElement);
			Element source = document.createElement("source");
			source.appendChild(document.createTextNode(filename+".bmp"));
			Element lineDirection = document.createElement("lineDirection");
			//20080715 shimizu wrote
			if(TextType.isHorizontal()){
			  lineDirection.appendChild(document.createTextNode("Horizontal"));
			}else{
			lineDirection.appendChild(document.createTextNode("Vertical"));
			}
			//
			segmentInfoElement.appendChild(source);
			segmentInfoElement.appendChild(lineDirection);
			segmentElement = document.createElement("segments");
			segmentInfoElement.appendChild(segmentElement);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (FactoryConfigurationError e) {
			e.printStackTrace();
		}
		

		for(int i=0;i<segments.size();i++){
			LineSegment segment = (LineSegment)segments.get(i);
			Element lineElement = this.getLineElement(document,segment);
			segmentElement.appendChild(lineElement);
		}
		
		XMLSaver saver = new XMLSaver(document,folderPath+filename+".xml");

		saver.save();
	}
	
	public void createDSCFile(String absolutePath,boolean showMessage){
		ProcessBuilder segfo2dscBuilder = new ProcessBuilder("Segfo2dsc.exe","-nm","-"+absolutePath);
		try {
			Process process = segfo2dscBuilder.start();
			process.waitFor();
			if(showMessage){
				JOptionPane.showMessageDialog(null,"file created");
			}
			
		} catch (IOException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	private Element getLineElement(Document doc,LineSegment segment){
		Element lineElement = doc.createElement("line");
		Element vertexes = doc.createElement("vertexes");
		lineElement.appendChild(vertexes);
		
		List points = segment.getPoints();
		for(int i=0;i<points.size();i++){
			Element vertex = doc.createElement("vertex");
			Point2D point = (Point2D)points.get(i);
			int x = (int)point.getX();
			int y = (int)point.getY();
			Element xElement = doc.createElement("x");
			Element yElement = doc.createElement("y");
			xElement.appendChild(doc.createTextNode(""+x));
			yElement.appendChild(doc.createTextNode(""+y));
			vertex.appendChild(xElement);
			vertex.appendChild(yElement);
			vertexes.appendChild(vertex);
		}
		
		return lineElement;
		
	}
}
