/* $Id: TextSearchPanel.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.text_search.swingui;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.StyleContext;

import smart_gs.PreferenceManager;
import smart_gs.all_text_search.SearchAllDialogManager;
import smart_gs.dictionary.DictionaryDialog;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.spread_selection.ScopePanelAction;
import smart_gs.spread_selection.SetScopePanel;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.text_search.SearchTextAction;
import smart_gs.text_search.logical.SearchResult;
import smart_gs.text_search.logical.TextSearchConstants;


@SuppressWarnings("serial")

public class TextSearchPanel extends JPanel {
	//͈͂̎w
	private SetScopePanel scopePanel;
	
	private JRadioButton allType;
	private JRadioButton firstIDAT;
	//20080901. Texť̂߂̃WI{^ݒu
	private JRadioButton userNote;
	private JRadioButton secondIDAT;
	private JRadioButton thirdIDAT;
    private JTextField queryTextPane;
    private JTextField queryReplacePane;

    private JCheckBox caseSensitiveBox;
    private JCheckBox regularExpressionsBox;
    private String queryText = null;
    private JButton search;
    private JButton replace;
    
    private static boolean allTypeSelected = true;
    private static boolean firstidatSelected;
    private static boolean userNoteSelected;
    private static boolean secondidatSelected;
    private static boolean thirdidatSelected;
    private static String queryTextPaneText;
    private static String queryReplacePaneText;
    private static boolean caseSensitiveBoxSelected;
    private static boolean regularExpressionsBoxSelected;
    
	public TextSearchPanel(){
//		super(new JPanel());
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		this.add(mainPanel, BorderLayout.CENTER);
		
		JPanel queryTextPanel = new JPanel();
		queryTextPanel.setLayout(new BorderLayout());
		queryTextPanel.setBorder(new TitledBorder(""));
		
		
		this.queryTextPane = new JTextField();
		this.queryTextPane.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		this.queryTextPane.setText(queryTextPaneText);
		
		this.queryReplacePane = new JTextField();
		this.queryReplacePane.setFont(new Font(StyleContext.DEFAULT_STYLE,Font.PLAIN,20));
		this.queryReplacePane.setText(queryReplacePaneText);

//		queryTextPanel.add(queryTextPane,BorderLayout.CENTER);

		
//		Panel findPanel = new Panel();
//		findPanel.setLayout(new GridLayout(2, 2));
//		findPanel.add(new JLabel("Find:"));
//		findPanel.add(queryTextPane);
//		findPanel.add(new JLabel("Replace With:"));
//		findPanel.add(new JLabel("A2"));


		GridBagConstraints c = new GridBagConstraints();
		JPanel findPanel = new JPanel(new GridBagLayout());
		c.gridheight = 1;
		c.gridwidth  = 1;
		c.gridy = 0;

		c.gridx = 0;
		c.weightx = 0.0;
		c.insets = new Insets(2, 2, 2, 0);
		c.anchor = GridBagConstraints.WEST;
		findPanel.add(new JLabel("Find:"), c);
		
		c.gridx = 1;
		c.weightx = 1.0;
		c.fill = GridBagConstraints.HORIZONTAL;
		findPanel.add(queryTextPane, c);
		

		c.gridy = 1;
		c.gridx = 0;
		c.weightx = 0.0;
		c.insets = new Insets(2, 2, 2, 0);
		c.anchor = GridBagConstraints.WEST;
		findPanel.add(new JLabel("Replace With:"), c);
		
		c.gridx = 1;
		c.weightx = 1.0;
		c.fill = GridBagConstraints.HORIZONTAL;
		findPanel.add(queryReplacePane, c);

		queryTextPanel.add(findPanel,BorderLayout.CENTER);
		
		
		Panel boxPanel = new Panel();
		boxPanel.setLayout(new BorderLayout());
		caseSensitiveBox = new JCheckBox("Case sensitive");
		regularExpressionsBox = new JCheckBox("Regular expressions");
		boxPanel.add(regularExpressionsBox,BorderLayout.WEST);
		boxPanel.add(caseSensitiveBox,BorderLayout.CENTER);
		queryTextPanel.add(boxPanel, BorderLayout.SOUTH);
		
		mainPanel.add(queryTextPanel, BorderLayout.NORTH);
		
		JPanel optionPanel = new JPanel(new GridLayout(1,2));
		mainPanel.add(optionPanel, BorderLayout.CENTER);
		
		
		/*
		 * ͈͂̎wSetScopePanelɈڂ
		 */
		this.scopePanel = new SetScopePanel(true);
		this.scopePanel.setScopePanelAction(new TextSearchDialogScopePanelAction());

		optionPanel.add(scopePanel);				
		
		JPanel documentTypePanel = new JPanel(new GridLayout(4,1));
		documentTypePanel.setBorder(new TitledBorder("document type"));
		this.userNote = new JRadioButton("Notes");
		this.userNote.setSelected(userNoteSelected);
		this.firstIDAT = new JRadioButton(Preference.getInstance().getFirstIDATName());
		this.firstIDAT.setSelected(firstidatSelected);
		this.secondIDAT = new JRadioButton(Preference.getInstance().getSecondIDATName());
		this.secondIDAT.setSelected(secondidatSelected);
		this.thirdIDAT = new JRadioButton(Preference.getInstance().getThirdIDATName());
		this.thirdIDAT.setSelected(thirdidatSelected);
		this.allType = new JRadioButton("All Document Types");
		this.allType.setSelected(allTypeSelected);
		this.caseSensitiveBox.setSelected(caseSensitiveBoxSelected);
		this.regularExpressionsBox.setSelected(regularExpressionsBoxSelected);
		ButtonGroup group2 = new ButtonGroup();
		
		group2.add(firstIDAT);
		group2.add(secondIDAT);
		group2.add(thirdIDAT);
		group2.add(userNote);
		group2.add(allType);
		
		firstIDAT.addActionListener(new DocumentTypeSelectAction());
		secondIDAT.addActionListener(new DocumentTypeSelectAction());
		thirdIDAT.addActionListener(new DocumentTypeSelectAction());
		userNote.addActionListener(new DocumentTypeSelectAction());
		allType.addActionListener(new DocumentTypeSelectAction());
		
		documentTypePanel.add(firstIDAT);
		documentTypePanel.add(secondIDAT);
		documentTypePanel.add(thirdIDAT);
		documentTypePanel.add(userNote);
		documentTypePanel.add(allType);
		optionPanel.add(documentTypePanel);
		
		JPanel buttonPanel = new JPanel();
		search = new JButton("Search");
		search.addActionListener(new SearchAction());
		buttonPanel.add(search);
		
		replace = new JButton("Replace");
		replace.addActionListener(new ReplaceAction());
		buttonPanel.add(replace);

		mainPanel.add(buttonPanel,BorderLayout.SOUTH);
		
		// Ԃɐݒ肷.
//		this.scopePanel.execScopePanelAction();

//		this.setLocationRelativeTo(null);
//		this.pack();
	}
	private class SearchAction implements ActionListener{
		int documentType;
		public void actionPerformed(ActionEvent e){
			queryText = queryTextPane.getText();
			if(queryText.equals("")){
				JOptionPane.showMessageDialog(null, "type any text");				
			}else if(scopePanel.isImageDictionary()){
				DictionaryDialog dictionaryDialog = new DictionaryDialog(WorkspaceWindow.getInstance(),"Dictionary",false,0);
				dictionaryDialog.search(queryText,regularExpressionsBox.isSelected(),caseSensitiveBox.isSelected());
				dictionaryDialog.setVisible(true);
			}else{
				queryTextPaneText = queryText;
				queryReplacePaneText = queryReplacePane.getText();
				firstidatSelected = firstIDAT.isSelected();
				thirdidatSelected = thirdIDAT.isSelected();
				secondidatSelected = secondIDAT.isSelected();
				allTypeSelected = allType.isSelected();
				userNoteSelected = userNote.isSelected();
				caseSensitiveBoxSelected = caseSensitiveBox.isSelected();
				regularExpressionsBoxSelected = regularExpressionsBox.isSelected();
				
				if(firstIDAT.isSelected()) {
					documentType = TextSearchConstants.FIRSTIDAT;
				}else if(thirdIDAT.isSelected()){
					documentType =TextSearchConstants.THIRDIDAT;
				}else if(secondIDAT.isSelected()){
					documentType = TextSearchConstants.SECONDIDAT;
				}else if(allType.isSelected()){
					documentType = TextSearchConstants.ALLDOCUMENT;
				}else if(userNote.isSelected()){
					documentType = TextSearchConstants.TEXT;
				}
				search(queryText,documentType,caseSensitiveBox.isSelected(),regularExpressionsBox.isSelected());
			}	
		}
	}
	private class DocumentTypeSelectAction implements ActionListener{
		public void actionPerformed(ActionEvent e){
			if(userNote.isSelected()){
				scopePanel.setEnabled(false);
			}else {
				scopePanel.setEnabled(true);
			}
		}
	}

	private class ReplaceAction implements ActionListener{
		int documentType;
		public void actionPerformed(ActionEvent e){
			queryText = queryTextPane.getText();
			if(queryText.equals("")){
				JOptionPane.showMessageDialog(null, "type any text");
			}else if(scopePanel.isImageDictionary()){
				// x
			}else{
				queryTextPaneText = queryText;
				queryReplacePaneText = queryReplacePane.getText();
				firstidatSelected = firstIDAT.isSelected();
				thirdidatSelected = thirdIDAT.isSelected();
				secondidatSelected = secondIDAT.isSelected();
				allTypeSelected = allType.isSelected();
				userNoteSelected = userNote.isSelected();
				caseSensitiveBoxSelected = caseSensitiveBox.isSelected();
				regularExpressionsBoxSelected = regularExpressionsBox.isSelected();
				
				if(firstIDAT.isSelected()) {
					documentType = TextSearchConstants.FIRSTIDAT;
				}else if(thirdIDAT.isSelected()){
					documentType =TextSearchConstants.THIRDIDAT;
				}else if(secondIDAT.isSelected()){
					documentType = TextSearchConstants.SECONDIDAT;
				}else if(allType.isSelected()){
					documentType = TextSearchConstants.ALLDOCUMENT;
				}else if(userNote.isSelected()){
					documentType = TextSearchConstants.TEXT;
				}
				SearchAllDialogManager.setting(queryText, queryReplacePaneText, regularExpressionsBoxSelected, caseSensitiveBoxSelected);
				int scope = 0;
				String spreadSelection = "";
				if(scopePanel.isAll()){
					scope = 0;
				}else if(scopePanel.isCurrentDirectory()){
					scope = 1;
				}else if(scopePanel.isSelectSpread()){
					scope = 2;
					spreadSelection = scopePanel.getSelectedPage();
				}
				SearchAllDialogManager.findfirst(documentType,scope,spreadSelection);
//				dispose();
			}	
		}
	}

	private void search(String queryText, int documentType,boolean isCaseSensitive,boolean isRegularExpressions){
//		List<Spread> spreads = this.getSpreadsToSearch();
		List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
		ArrayList<Spread> spreadsToSearch = new ArrayList<Spread>();
		for(int i=0;i<spreads.size();i++){
			spreadsToSearch.add(spreads.get(i));
		}		
		SearchTextAction searchAction = new SearchTextAction(queryText,spreadsToSearch,documentType,isCaseSensitive,isRegularExpressions);
		searchAction.execute();
		ArrayList<SearchResult> results = (ArrayList<SearchResult>)searchAction.getResults();
		new SearchResultViewer(queryText,results).setVisible(true);				
//		dispose();
	}
	
	public void actionPerformed(ActionEvent e) {
		
	}
	class TextSearchDialogScopePanelAction implements ScopePanelAction{

		public void actionPerformed(SetScopePanel setScopePanel) {
			if(setScopePanel.isImageDictionary()){
				allType.setEnabled(false);
				firstIDAT.setEnabled(false);
				userNote.setEnabled(false);
				secondIDAT.setEnabled(false);
				thirdIDAT.setEnabled(false);
				replace.setEnabled(false);
			}else{
				allType.setEnabled(true);
				firstIDAT.setEnabled(true);
				userNote.setEnabled(true);
				secondIDAT.setEnabled(true);
				thirdIDAT.setEnabled(true);
				replace.setEnabled(true);
			}
		}
		
	}
}
