/* $Id: SpreadSelectPopupMenu.java 147 2011-04-26 17:07:17Z minao $ */
package smart_gs.swingui;

import java.util.List;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import smart_gs.drawing_tool.action.SheetSelectAction;
import smart_gs.logical.GSResource;
import smart_gs.logical.Sheet;
import smart_gs.logical.Spread;
import smart_gs.logical.SpreadDirectory;
import smart_gs.logical.SpreadTree;
import smart_gs.swingui.tree.action.AddDirectoryAction;
import smart_gs.swingui.tree.action.AddSpreadsAction;
import smart_gs.swingui.tree.action.DeleteSelectedItemsAction;
import smart_gs.swingui.tree.action.SortSelectedItemsByNameAction;

// 2011.03.14 shayashi changed
public class SpreadSelectPopupMenu extends JPopupMenu {
	private JMenuItem setSheetNameItem;
	private JMenuItem showSheetItem;
	
	public SpreadSelectPopupMenu(SpreadTree tree){
//	2011.03.15 shayashi
//		changed much including the name of class.
		TreePath[] paths = tree.getSelectionPaths();
		int size;
		if (paths != null) size = paths.length; else return;

		if(size == 0){
			JOptionPane.showMessageDialog(null, "Select items in ImageTree");
		}else if (size == 1){
			GSResource selectedItem = (GSResource)((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
			if (selectedItem instanceof SpreadDirectory){
				JMenuItem deleteItem = new JMenuItem("Delete Directory");
				deleteItem.addActionListener(new DeleteSelectedItemsAction(tree));
				this.add(deleteItem);
				SpreadDirectory spreadDirectory = (SpreadDirectory)selectedItem;
				JMenuItem addItem = new JMenuItem("Add Spreads");
				addItem.addActionListener(new AddSpreadsAction(spreadDirectory.getFile(),tree,spreadDirectory));
				this.add(addItem);
				JMenuItem addDirectory = new JMenuItem("Add Directory");
				addDirectory.addActionListener(new AddDirectoryAction(spreadDirectory.getFile(),tree,spreadDirectory));
				this.add(addDirectory);
			} else {
				JMenuItem deleteItem = new JMenuItem("Delete Spread");
				deleteItem.addActionListener(new DeleteSelectedItemsAction(tree));
				this.add(deleteItem);
			}
		} else {
			JMenuItem deleteItem = new JMenuItem("Delete Selected Items");
			deleteItem.addActionListener(new DeleteSelectedItemsAction(tree));
			this.add(deleteItem);
			JMenuItem sortItemByName = new JMenuItem("Sort Selected Items by Name");
			sortItemByName.addActionListener(new SortSelectedItemsByNameAction(tree));
			this.add(sortItemByName);
		}
	}
}
