/* $Id: CreateShortCutDialog.java 144 2011-04-25 00:44:06Z minao $ */
package smart_gs.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;

import org.xml.sax.SAXException;

import smart_gs.logical.StandardTextDocument;
import smart_gs.smleditor.swingui.GSEditorTextPane;
import smart_gs.smleditor.swingui.GSWysiwygPanel;
import smart_gs.swingui.toolbar.GSEditorToolBar;
import sml_editor.swingui.AbstractEditorPanel;
import sml_editor.swingui.EditorFrame;


@SuppressWarnings("serial")
public class CreateShortCutDialog extends JDialog implements EditorFrame{
	
	private JTextField nameField;
	private GSEditorTextPane textPane;
	
	private boolean isCanceled = false;
	private StandardTextDocument document;
	public CreateShortCutDialog(JFrame parent){
		super(parent,"Dialog",true);
	//	super(parent,"Dialog");
		this.getContentPane().setLayout(new BorderLayout());
	//	this.source = source;
		

		
		JPanel mainPanel = new JPanel(new BorderLayout());
		JPanel namePanel = new JPanel();
		namePanel.setBorder(new LineBorder(Color.BLACK));
		namePanel.add(new JLabel("Name: "));
		this.nameField = new JTextField(20);
		namePanel.add(this.nameField);
	    mainPanel.add(namePanel,BorderLayout.NORTH);
		
//	    SmlController controller = null;
//		try {
//			controller = new SmlController("<xml></xml>");
			JScrollPane scrollPane = new JScrollPane();
			this.document = new StandardTextDocument("","");
		    this.textPane = new GSEditorTextPane(document,GSEditorTextPane.BASIC);
		    AbstractEditorPanel panel = new GSWysiwygPanel(this,this.textPane);

		    scrollPane.setViewportView(panel);
		    mainPanel.add(scrollPane,BorderLayout.CENTER);
//		} catch (SAXException e) {
//			e.printStackTrace();
//		}
		
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
		this.getContentPane().add(new GSEditorToolBar(this.textPane),BorderLayout.NORTH);
		
		JPanel buttonPanel = new JPanel();
		JButton ok = new JButton("OK");
		ok.addActionListener(new OKAction());
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new CancelAction());
		buttonPanel.add(ok);
		buttonPanel.add(cancel);
		
		this.getContentPane().add(buttonPanel,BorderLayout.SOUTH);
		
		this.setSize(400,400);
	}
	public String getName(){
		return this.nameField.getText();
	}
//	public String getSource(){
//		String source = this.textPane.getController().document2Source();
//		return source;
//	}
	public StandardTextDocument getDocument(){
		return this.document;
	}
	public boolean isCanceled(){
		return this.isCanceled;
	}
	private class OKAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
//			document.setSource(textPane.getGSHTMLEditorTextPane().getController().document2Source());
			dispose();
		}
	}
	private class CancelAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			isCanceled = true;
			dispose();
		}
	}
	public void setEditorToolBar(JToolBar toolbar) {
		
	}
	@Override
	public void setVisible(boolean b) {
		super.setVisible(b);
	}
}
