/* $Id: AbstractGSWindow.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.swingui;


import javax.swing.JFrame;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.Spread;
import smart_gs.smleditor.swingui.GSEditorFrame;
import smart_gs.smleditor.swingui.GSTabbedPane;

/**
 * 
 * @author kazuaki kobayashi
 *
 * 
 */
public abstract class AbstractGSWindow extends JFrame implements GSEditorFrame{
	
	protected GSTabbedPane tabbedPane;
	
	public AbstractGSWindow(String title){
		super(title);
	}
	
	
	public abstract GSTabbedPane createTabbedPane(Spread spread);
	
	public void setSpread(Spread spread){
		if(this.tabbedPane != null){
			this.tabbedPane.clear();
		}
		this.tabbedPane = this.createTabbedPane(spread);		
	}
	
	public void close(){
		this.tabbedPane.clear();
	}
	
	public abstract Spread getSpread();
	public abstract void updateGUI(Spread spread);
	
	public abstract SpreadCanvas getSpreadCanvas();
	
}
