/* $Id: ConnectionRightClickMenu.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.reasoning_web.swingui.action;

import javax.swing.JPopupMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import reasoning_web.logical.Connection;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class ConnectionRightClickMenu extends JPopupMenu {
	private JMenuItem delete;
	private JMenuItem show;
	private GS_RWElement element;
	
	public ConnectionRightClickMenu(GS_RWElement element) {
		this.element = element;
		this.show = new JMenuItem("Show");
		this.show.addActionListener(new ElementAction());
		this.add(show);
		this.delete = new JMenuItem("Delete");
		this.delete.addActionListener(new ElementAction());
		this.add(delete);
	}

	class ElementAction implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			if (e.getSource().equals(delete)) {
				int i = JOptionPane.showConfirmDialog(null, "Delete this connection?");
				if(i == JOptionPane.YES_OPTION){
					GS_RWRepository.getInstance().removeConnection((Connection)element);
					
				}
			}
			if(e.getSource().equals(show)){
				element.show();
			}
		}
	}
}
