/* $Id: ReasoningWebFrame.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * 쐬: 2006/06/02
 *
 */
package smart_gs.reasoning_web.swingui;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;
import javax.swing.JPanel;
import smart_gs.reasoning_web.desktop.logical.DeskTopFolder;
import smart_gs.reasoning_web.desktop.swingui.FolderPanel;

/**
 * @author kazuaki kobayashi
 *
 * 
*/
@SuppressWarnings("serial")

public class ReasoningWebFrame extends JFrame {
	
	private static ReasoningWebFrame singleton = new ReasoningWebFrame();
		
	private LinkViewPanel linkViewPanel;
	private DesktopPanel desktopPanel;
	public static final int LINK_VIEW = 0;
	public static final int DESKTOP_VIEW = 1;
	private int mode = LINK_VIEW;

	
	private ReasoningWebFrame(){
		super("Reasoning Web");
		this.linkViewPanel = new LinkViewPanel();
		this.desktopPanel = new DesktopPanel();	
		this.getContentPane().setLayout(new BorderLayout());
		this.setJMenuBar(new RWMenubar());
		this.getContentPane().add(this.linkViewPanel.getToolBar(),BorderLayout.NORTH);
		this.getContentPane().add(this.linkViewPanel,BorderLayout.CENTER);		
		this.setSize(900,700);
	}
	
	public void setMainPanel(FolderPanel panel){
		this.desktopPanel.setMainPanel(panel);
	}
	
	//view mode̐؂ւilink view-desktop viewj
	public void setMode(int mode){
		this.mode = mode;
		if(this.mode == LINK_VIEW){
			this.getContentPane().remove(this.desktopPanel);
			this.getContentPane().add(this.linkViewPanel,BorderLayout.CENTER);
			this.getContentPane().remove(this.desktopPanel.getToolBar());
			this.getContentPane().add(this.linkViewPanel.getToolBar(),BorderLayout.NORTH);
		}else if(this.mode == DESKTOP_VIEW){
			this.getContentPane().remove(this.linkViewPanel);
			this.getContentPane().remove(this.linkViewPanel.getToolBar());
			this.getContentPane().add(this.desktopPanel,BorderLayout.CENTER);
			this.getContentPane().add(this.desktopPanel.getToolBar(),BorderLayout.NORTH);
		}
		validate();
		repaint();
	}
	
	//UtilityPanelĂяo郁\bh
	public static ReasoningWebFrame getInstance(){
		return singleton;
	}
	
	//DesctopPanelĂяo
	public void back(){
		if(this.mode == DESKTOP_VIEW){
			this.desktopPanel.back();
		}
	}
	public DesktopPanel getDesktopPanel() {
		return desktopPanel;
	}
	
	//LinkViewPanelĂяo
	public void setLocalView(JPanel panel){
		this.linkViewPanel.setLocalView(panel);
	}
	public void reload(){
		this.linkViewPanel.reload();
	}
	public DeskTopFolder getCurrentFolder() {
		return this.desktopPanel.getCurrentFolder();
	}
	public ElementsPanel getElementsPanel() {
		return this.linkViewPanel.getElementsPanel();
	}
	
}
