/* $Id: XML2RWElementConverter.java 182 2011-05-26 20:15:53Z minao $ */
package smart_gs.reasoning_web.logical;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBacket;
import smart_gs.logical.GSResource;
import smart_gs.logical.Spread;
import smart_gs.logical.StandardTextDocument;
import smart_gs.logical.URICreator;
import smart_gs.logical.URISolver;
import smart_gs.logical.XML2ResourceConverter;
import smart_gs.reasoning_web.desktop.logical.ShortCut;

public class XML2RWElementConverter {
	
	public static GS_RWElement convert(Element element){
		String tagname = element.getNodeName();
		
		if(tagname.equals("standardDocument")){
			return getStandardDocument(element);
		}else if(tagname.equals(URICreator.RWPACKAGE)){
			return getPackage(element);
		}else if(tagname.equals(URICreator.GSQUERY)){
			return getQuery(element);
		}else if(tagname.equals(URICreator.SHORTCUT)){
			return getShortCut(element);
		}else if(tagname.equals(URICreator.BACKET)){
			return QueryBacket.restore(element);
		}
		else{
			return XML2ResourceConverter.convert(element);
		}
		
	}
	
	
	private static GS_RWElement getShortCut(Element element) {
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		ShortCut shortcut = new ShortCut();
		shortcut.setName(name);
		shortcut.setString(source);
		NodeList list = element.getChildNodes();
		for(int i=0;i<list.getLength();i++){
			if(list.item(i).getNodeType() == Node.ELEMENT_NODE){
				GS_RWElement resource = XML2RWElementConverter.convert((Element)list.item(i));
				
				shortcut.setResouce(resource);
			}
		}
		shortcut.setURIs(uri, originalURI);
		if (version.equals("")) {
			shortcut.setVersion("before 0.8");
		} else {
			shortcut.setVersion(version);
		}
		return shortcut;
	}


	private static GS_RWElement getQuery(Element element) {
		boolean hasSpread = new Boolean(element.getAttribute("hasSpread"));
		String spreadURI = null;
		String name = element.getAttribute("name");
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		if(hasSpread){
			spreadURI = element.getAttribute("spreadURI");
		}
		int x = new Integer(element.getAttribute("x"));
		int y = new Integer(element.getAttribute("y"));
		int width = new Integer(element.getAttribute("width"));
		int height = new Integer(element.getAttribute("height"));
		
		GSQuery query = null;
		if(hasSpread){
			Spread spread = (Spread)URISolver.getResource(spreadURI);
			query = new GSQuery(spread,spread.getDscFile(),new Rectangle(x,y,width,height));
			query.setName(name);
		}else{
			String dscFilePath = element.getAttribute("dscfile");
			String imagePath = element.getAttribute("imagePath");
//			Image image = new ImageIcon(imagePath).getImage();
			Image image = null;
			try {
				
				image = ImageIO.read(new File(imagePath));
			} catch (IOException e) {
				e.printStackTrace();
			}
			File dscFile = new  File(dscFilePath);
			query = new GSQuery(image,dscFile,new Rectangle(x,y,width,height));
			query.setName(name);
		}
		query.setURIs(uri, originalURI);
		if (version.equals("")) {
			query.setVersion("before 0.8");
		} else {
			query.setVersion(version);
		}
		return query;
	}


	private static GS_RWPackage getPackage(Element element){
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		GS_RWPackage gsPackage = new GS_RWPackage(uri,originalURI,true);
		gsPackage.setName(name);
		gsPackage.setSource(source);
		
		NodeList children = element.getChildNodes();
		for(int i=0;i<children.getLength();i++){
			Node node = children.item(i); 
			if(node.getNodeType() == Node.ELEMENT_NODE){
				GS_RWElement child = XML2RWElementConverter.convert((Element)node);
				gsPackage.add(child);
			}
		}
		if (version.equals("")) {
			gsPackage.setVersion("before 0.8");
		} else {
			gsPackage.setVersion(version);
		}
		return gsPackage;
	}
	
	private static StandardTextDocument getStandardDocument(Element element){
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		String name = element.getAttribute("name");
		String source = element.getAttribute("source");
		StandardTextDocument doc = new StandardTextDocument(source,name,uri,originalURI);
		if (version.equals("")) {
			doc.setVersion("before 0.8");
		} else {
			doc.setVersion(version);
		}

		return doc;
	}
	
	// for debug
	private static void debug1(String methodName, String uri, String originalURI) {
		System.out.println("debug print from XML2RWElementConverter, " + methodName);
		System.out.println("  attribute uri: " + uri);
		System.out.println("  attribute originalURI: " + originalURI);
	}
	private static void debug2(String uri, String originalURI) {
		System.out.println("  restored uri: " + uri);
		System.out.println("  restored originalURI: " + originalURI);
	}

}
