/* $Id: SetDictionaryFilePathAction.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.menu.action;

import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import smart_gs.logical.Preference;
import smart_gs.menu.DirectorySettingWindow;

public class SetDictionaryFilePathAction extends SetDirectoryPathAction implements ActionListener{

	public SetDictionaryFilePathAction(){
		super();
		this.chooser.setDialogTitle("Dictionary file");
		chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
		
		chooser.setFileFilter(new ImageFileFilter());
//		chooser.setSelectedFile(new File(getOldPath()));
	}
	@Override
	protected String getOldPath() {
		// TODO Auto-generated method stub
		return Preference.getInstance().getInstance().getDictionary();
	}

	@Override
	protected void validateNewPath(String newPath) {
		// TODO Auto-generated method stub
		DirectorySettingWindow.getInstance().setDictionaryFileTextField(newPath);
	}
	public class ImageFileFilter extends FileFilter{


		public boolean accept(File pathname) {
			String name = pathname.getAbsolutePath();
			if(name.endsWith("xml")){
				return true;
			}else if(pathname.isDirectory()){
				return true;
			}
			return false;
		}

		@Override
		public String getDescription() {
			return "xml";
		}
	}
}
