/* $Id: BookmarkListAction.java 144 2011-04-25 00:44:06Z minao $ */
package smart_gs.menu.action;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;

import smart_gs.logical.BookmarkList;
import smart_gs.logical.region.BookmarkRegion;

@SuppressWarnings("serial")
public class BookmarkListAction extends AbstractAction {
	
	List<BookmarkRegion> bookmarks;
	
	public BookmarkListAction(List<BookmarkRegion> bookmarks) {
		this.bookmarks = bookmarks;
	}
	

	@Override
	public void actionPerformed(ActionEvent e) {
		String source = ((JMenuItem)e.getSource()).getText();
		DefaultListModel model = new DefaultListModel();
		for (BookmarkRegion b:bookmarks) {
			model.addElement(b);
		}
		BookmarkList list = new BookmarkList(model);
		list.setVisibleRowCount(10);
		JScrollPane sPane = new JScrollPane(list);
		JFrame frame = null;
		if (source.equals("Jump")) {
		    frame = new BookmarkJumpSelectionListener(list);
		} else if (source.equals("Open")) {
		    frame = new BookmarkOpenSelectionListener(list);
		}
	    frame.setSize(new Dimension(300,200));
	    frame.add(sPane,BorderLayout.CENTER);
	    list.addListSelectionListener((ListSelectionListener)frame);
	    frame.setVisible(true);
	    frame.setAlwaysOnTop(true);
	}
}
