/* $Id: BookmarkJumpSelectionListener.java 144 2011-04-25 00:44:06Z minao $ */
package smart_gs.menu.action;

import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.logical.BookmarkList;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.WorkspaceWindow;

public class BookmarkJumpSelectionListener extends JFrame 
			implements ListSelectionListener {

	private static boolean ALTERNATE = true;
	private BookmarkList list;

	public BookmarkJumpSelectionListener(BookmarkList list) {
		super("Jump");
		this.list = list;
	}

	@Override
	public void valueChanged(ListSelectionEvent arg0) {
		if (ALTERNATE) {
			BookmarkRegion bookmark = (BookmarkRegion)(list.getSelectedValue());
			Spread spread = bookmark.getSpread();
			WorkspaceWindow.getInstance().setSpread(spread);
			WorkspaceWindow.getInstance().setImageSearch(spread.toString());
			SpreadCanvas canvas = WorkspaceWindow.getInstance().getSpreadCanvas();
			canvas.imageLabel.showImage();
			canvas.imageLabel.moveTo(((Region)bookmark).getCornerPoint());
			canvas.selectBookmark(bookmark);
		}
		ALTERNATE = !ALTERNATE;
	}

}
