/* $Id: PreferenceMenu.java 182 2011-05-26 20:15:53Z minao $ */
package smart_gs.menu;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;


import jp.ac.hokudai.meme.core_smart_gs.searcher.IDocumentSearcher;

import smart_gs.drawing_tool.state.UniSelectedState;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.drawing_tool.view.MarkerView;
import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.image_search.GSSearchEngine;
import smart_gs.image_search.logical.TextType;
import smart_gs.logical.Preference;
import smart_gs.menu.action.BookmarkChangeDefaultSizeAction;
import smart_gs.menu.action.ChangeSearchTypeAction;
import smart_gs.menu.action.ChangeTextTypeAction;
import smart_gs.menu.action.LoadFileAction;
import smart_gs.menu.action.MarkerChangeDefaultBreadthAction;
import smart_gs.menu.action.MarkerChangeDefaultColorAction;
import smart_gs.menu.action.MemoPadChangeDefaultColorAction;
import smart_gs.menu.action.RectangleMoveAction;
import smart_gs.menu.action.SetCurrentDirectoryAction;
import smart_gs.menu.action.SetImageFolderPathAction;
import smart_gs.menu.action.SetDocumentFolderPathAction;
import smart_gs.menu.action.SetDscFolderPathAction;
import smart_gs.menu.action.SetLineFolderPathAction;
import smart_gs.menu.action.SetSmart_gsFolderPathAction;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import webdav.preference.ProxySetting;
import webdav.preference.WebDavSetting;

@SuppressWarnings("serial")
public class PreferenceMenu extends JMenu {

	public PreferenceMenu(String title, AbstractGSWindow window) {
		super(title);

		JMenuItem userName = new JMenuItem("Set User Name");
		userName.addActionListener(new ChangeUserNameAction());
		this.add(userName);
		
//	2011.03.04 shayashi	
//        //20080715 shimizu
//		/*
//		 * ꕔ̃j[WI{^j[ɕύX
//		 */
////		JMenu changeMainPanel = new JMenu("Change Main Panel");
////		int panel = PreferenceManager.getInstance().getMainDocumentType();
////		JMenuItem image = new JRadioButtonMenuItem("Image",panel==GSConstants.IMAGE);
////		JMenuItem firstIDAT = new JRadioButtonMenuItem(Preference.getInstance().getFirstIDATName(),panel==GSConstants.FIRSTIDAT);
////		JMenuItem thirdIDAT = new JRadioButtonMenuItem(Preference.getInstance().getThirdIDATName(),panel==GSConstants.THIRDIDAT);
////		JMenuItem secondIDAT = new JRadioButtonMenuItem(Preference.getInstance().getSecondIDATName(),panel==GSConstants.SECONDIDAT);
////		image.addActionListener(new ChangeMainTypeAction(GSConstants.IMAGE));
////		firstIDAT.addActionListener(new ChangeMainTypeAction(
////				GSConstants.FIRSTIDAT));
////		thirdIDAT.addActionListener(new ChangeMainTypeAction(
////				GSConstants.THIRDIDAT));
////		secondIDAT.addActionListener(new ChangeMainTypeAction(
////				GSConstants.SECONDIDAT));
////		ButtonGroup panelGroup = new ButtonGroup();
////		panelGroup.add(image);
////		panelGroup.add(firstIDAT);
////		panelGroup.add(thirdIDAT);
////		panelGroup.add(secondIDAT);
////		changeMainPanel.add(image);
////		changeMainPanel.add(firstIDAT);
////		changeMainPanel.add(thirdIDAT);
////		changeMainPanel.add(secondIDAT);
////		this.add(changeMainPanel);
		
//		2011.02.20 shayashi
		JMenuItem IDATNamesSetting = new JMenuItem("IDAT Names");
		IDATNamesSetting.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				IDATNamesSetting iDATNamesSetting = new IDATNamesSetting(WorkspaceWindow.getInstance(),true);
				iDATNamesSetting.setLocationRelativeTo(null);
				iDATNamesSetting.setVisible(true);
			}
		});
		this.add(IDATNamesSetting);

		//20090118 North Grid Add
		JMenu imageSearchEngine = new JMenu("Image Search Engine");
		boolean isExternalEngine = GSSearchEngine.getInstance().isUseExternalEngine();
		JMenuItem externalEngine = new JRadioButtonMenuItem("External",isExternalEngine);
		externalEngine.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				GSSearchEngine.getInstance().setUseExternalEngine(true);
			}
		});
		
		JMenuItem internalEngine = new JRadioButtonMenuItem("Internal",isExternalEngine==false);
		internalEngine.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				GSSearchEngine.getInstance().setUseExternalEngine(false);
			}
		});
		ButtonGroup imageSearchEngineGroup = new ButtonGroup();
		imageSearchEngineGroup.add(externalEngine);
		imageSearchEngineGroup.add(internalEngine);
		imageSearchEngine.add(externalEngine);
		imageSearchEngine.add(internalEngine);

		this.add(imageSearchEngine);
		
		
		
		//20090909 North Grid Add
		JMenu imageSearchType = new JMenu("Image Search Type in Dictionary");
		String type = Preference.getInstance().getInstance().getSearchImageDictionaryLogic();
		boolean isType1 = false;
		boolean isType2 = false;
		boolean isType3 = false;
		if(type.equals("0")){
			isType1 = true;
		}else if(type.equals("1")){
			isType2 = true;
		}else if(type.equals("2")){
			isType3 = true;
		}else {
			isType1 = true;
		}
		JMenuItem type1 = new JRadioButtonMenuItem("Type1",isType1);
		type1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().getInstance().setSearchImageDictionaryLogic("0");
			}
		});
		JMenuItem type2 = new JRadioButtonMenuItem("Type2",isType2);
		type2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().getInstance().setSearchImageDictionaryLogic("1");
			}
		});
		JMenuItem type3 = new JRadioButtonMenuItem("Type3",isType3);
		type3.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				Preference.getInstance().getInstance().setSearchImageDictionaryLogic("2");
			}
		});
		ButtonGroup imageSearchTypeGroup = new ButtonGroup();
		imageSearchTypeGroup.add(type1);
		imageSearchTypeGroup.add(type2);
		imageSearchTypeGroup.add(type3);

		imageSearchType.add(type1);
		imageSearchType.add(type2);
		imageSearchType.add(type3);

		this.add(imageSearchType);
		
		
		JMenu searchType = new JMenu("Search Type");
		int s = GSSearchEngine.getInstance().getSearchType();
		JMenuItem defaultType = new JRadioButtonMenuItem("Default",s==IDocumentSearcher.TYPE_NORMAL);
		defaultType.addActionListener(new ChangeSearchTypeAction(
				IDocumentSearcher.TYPE_NORMAL));
		JMenuItem dtw1 = new JRadioButtonMenuItem("DTW_1",s==IDocumentSearcher.TYPE_DTW_1);
		dtw1.addActionListener(new ChangeSearchTypeAction(
				IDocumentSearcher.TYPE_DTW_1));
		JMenuItem dtw2 = new JRadioButtonMenuItem("DTW_2",s==IDocumentSearcher.TYPE_DTW_2);
		dtw2.addActionListener(new ChangeSearchTypeAction(
				IDocumentSearcher.TYPE_DTW_2));
		ButtonGroup searchGroup = new ButtonGroup();
		searchGroup.add(defaultType);
		searchGroup.add(dtw1);
		searchGroup.add(dtw2);
		searchType.add(defaultType);
		searchType.add(dtw1);
		searchType.add(dtw2);

		this.add(searchType);
		//20080715 shimizu wrote
		JMenu textType = new JMenu("Text Type");
		JMenuItem horizontal = new JRadioButtonMenuItem("Horizontal",TextType.isHorizontal());
		horizontal.addActionListener(new ChangeTextTypeAction(
				TextType.HORIZONTAL));
		JMenuItem vertical = new JRadioButtonMenuItem("Vertical",TextType.isHorizontal()==false);
		vertical.addActionListener(new ChangeTextTypeAction(
				TextType.VERTICAL));
		ButtonGroup textTypeGroup = new ButtonGroup();
		textTypeGroup.add(horizontal);
		textTypeGroup.add(vertical);
		textType.add(horizontal);
		textType.add(vertical);
		
		this.add(textType);
		

		JMenuItem maxSearchNum = new JMenuItem("Set Search Found Size");
		this.add(maxSearchNum);
		maxSearchNum.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String sizeStr = JOptionPane
						.showInputDialog("Input Max Found Size");
				if (sizeStr == null) {
					return;
				}
				try {
					int size = Integer.parseInt(sizeStr);
					GSSearchEngine.getInstance().setMaxFound(size);
				} catch (NumberFormatException nfe) {
					nfe.printStackTrace();
				}
			}
		});

		JMenuItem load = new JMenuItem("Load All Images");
		load.addActionListener(new LoadFileAction());

		this.add(load);

		/*
		 * menu̒ǉ(2007/9/11) reactangleɊւ
		 */
		JMenu markupMenu = new JMenu("Markup"); // 2011/05/07 kukita altered the name of this menu item
		JMenu rectangleMove = new JMenu("Movability"); // 2010/12/01 kukita
		boolean rec = UniSelectedState.getInstance().getRectangleMovability();
		JMenuItem move = new JRadioButtonMenuItem("Movable",rec);
		JMenuItem notMove = new JRadioButtonMenuItem("UnMovable",rec==false);
		ButtonGroup recGroup = new ButtonGroup();
		recGroup.add(move);
		recGroup.add(notMove);
		rectangleMove.add(move);
		rectangleMove.add(notMove);
		markupMenu.add(rectangleMove); // 2010/12/01 kukita
		move.addActionListener(new RectangleMoveAction(true));
		notMove.addActionListener(new RectangleMoveAction(false));
		this.add(markupMenu);// 2010/12/01 kukita

		// 2010/11/30 kukita
		JMenu memoPadDefaultColor = new JMenu("MemoPad Default Color");
		Color memoPad_dc = MemoPadView.DEFAULT_COLOR;
		JMenuItem memoPad_yellow = 
			new JRadioButtonMenuItem("Yellow",memoPad_dc == MemoPadView.MEMOPAD_YELLOW);
		JMenuItem memoPad_cyan = 
			new JRadioButtonMenuItem("Cyan",memoPad_dc == MemoPadView.MEMOPAD_CYAN);
		JMenuItem memoPad_magenta = 
			new JRadioButtonMenuItem("Magenta",memoPad_dc == MemoPadView.MEMOPAD_MAGENTA);
		JMenuItem memoPad_green = 
			new JRadioButtonMenuItem("Green",memoPad_dc == MemoPadView.MEMOPAD_GREEN);
		ButtonGroup memoPadColorGroup = new ButtonGroup();
		memoPadColorGroup.add(memoPad_yellow);
		memoPadColorGroup.add(memoPad_cyan);
		memoPadColorGroup.add(memoPad_magenta);
		memoPadColorGroup.add(memoPad_green);
		memoPadDefaultColor.add(memoPad_yellow);
		memoPadDefaultColor.add(memoPad_cyan);
		memoPadDefaultColor.add(memoPad_magenta);
		memoPadDefaultColor.add(memoPad_green);
		memoPad_yellow.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_YELLOW));
		memoPad_cyan.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_CYAN));
		memoPad_magenta.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_MAGENTA));
		memoPad_green.addActionListener(new MemoPadChangeDefaultColorAction(MemoPadView.MEMOPAD_GREEN));
		markupMenu.add(memoPadDefaultColor);// 2010/12/01 kukita
		
		JMenu markerDefaultColor = new JMenu("Marker Default Color");
		Color marker_dc = MarkerView.DEFAULT_COLOR;
		JMenuItem marker_yellow = 
			new JRadioButtonMenuItem("Yellow",marker_dc == MarkerView.MARKER_YELLOW);
		JMenuItem marker_cyan = 
			new JRadioButtonMenuItem("Cyan",marker_dc == MarkerView.MARKER_CYAN);
		JMenuItem marker_magenta = 
			new JRadioButtonMenuItem("Magenta",marker_dc == MarkerView.MARKER_MAGENTA);
		JMenuItem marker_green = 
			new JRadioButtonMenuItem("Green",marker_dc == MarkerView.MARKER_GREEN);
		ButtonGroup markerColorGroup = new ButtonGroup();
		markerColorGroup.add(marker_yellow);
		markerColorGroup.add(marker_cyan);
		markerColorGroup.add(marker_magenta);
		markerColorGroup.add(marker_green);
		markerDefaultColor.add(marker_yellow);
		markerDefaultColor.add(marker_cyan);
		markerDefaultColor.add(marker_magenta);
		markerDefaultColor.add(marker_green);
		marker_yellow.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_YELLOW));
		marker_cyan.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_CYAN));
		marker_magenta.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_MAGENTA));
		marker_green.addActionListener(new MarkerChangeDefaultColorAction(MarkerView.MARKER_GREEN));
		markupMenu.add(markerDefaultColor);// 2010/12/01 kukita
		
		JMenuItem markerDefaultBreadth = new JMenuItem("Marker Default Breadth");
		markerDefaultBreadth.addActionListener(new MarkerChangeDefaultBreadthAction(window));
		markupMenu.add(markerDefaultBreadth);
		
		JMenu bookmarkDefaultSize = new JMenu("Bookmark Default Size");
		int ds = BookmarkView.DEFAULT_SIZE;
		JMenuItem  huge = new JRadioButtonMenuItem(100 + BookmarkView.HUGE + "%", ds == BookmarkView.HUGE);
		JMenuItem large = new JRadioButtonMenuItem(100 + BookmarkView.LARGE + "%", ds == BookmarkView.LARGE);
		JMenuItem normal = new JRadioButtonMenuItem(100 + BookmarkView.NORMAL + "%", ds == BookmarkView.NORMAL);
		JMenuItem small = new JRadioButtonMenuItem(100 + BookmarkView.SMALL + "%", ds == BookmarkView.SMALL);
		JMenuItem tiny = new JRadioButtonMenuItem(100 + BookmarkView.TINY + "%", ds == BookmarkView.TINY);
		ButtonGroup bookmarkSizeGroup = new ButtonGroup();
		bookmarkSizeGroup.add(huge);
		bookmarkSizeGroup.add(large);
		bookmarkSizeGroup.add(normal);
		bookmarkSizeGroup.add(small);
		bookmarkSizeGroup.add(tiny);
		bookmarkDefaultSize.add(huge);
		bookmarkDefaultSize.add(large);
		bookmarkDefaultSize.add(normal);
		bookmarkDefaultSize.add(small);
		bookmarkDefaultSize.add(tiny);
		huge.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.HUGE));
		large.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.LARGE));
		normal.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.NORMAL));
		small.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.SMALL));
		tiny.addActionListener(new BookmarkChangeDefaultSizeAction(BookmarkView.TINY));

		markupMenu.add(bookmarkDefaultSize);
		// 2007/10/7 kazuhiro kobayashi
		// FileChooserJƂ̍ŏ̃fBNgݒ
		JMenuItem setGsFolderPath = new JMenuItem("gs");
		setGsFolderPath.addActionListener(new SetCurrentDirectoryAction());
		// this.add(setCurrentDirectory);
		// 2007/10/10 kazuhiro kobayashi
		/*
		 * ÕtH_ɂ邱̃t@CgƂł
		 */
		JMenuItem setImageFolderPath = new JMenuItem("image");
		setImageFolderPath.addActionListener(new SetImageFolderPathAction());

		JMenuItem setDocumentFolderPath = new JMenuItem("textDocument");
		setDocumentFolderPath
				.addActionListener(new SetDocumentFolderPathAction());

		JMenuItem setDscFolderPath = new JMenuItem("dsc");
		setDscFolderPath.addActionListener(new SetDscFolderPathAction());

		JMenuItem setLineFolderPath = new JMenuItem("line");
		setLineFolderPath.addActionListener(new SetLineFolderPathAction());

		//2007/10/11 kazuhiro kobayashi
		JMenuItem setSmart_gsFolderPath = new JMenuItem("smart_gs");
		setSmart_gsFolderPath.addActionListener(new SetSmart_gsFolderPathAction());
		
		/* 20080909 name correspondance @\폜̂߁B@hashimoto
		 * 
		//2007/11/20 kazuhiro kobayashi
		JMenuItem setNameCorrespondenceFilePath = new JMenuItem("name correspondence");
		setNameCorrespondenceFilePath.addActionListener(new SetNameCorrespondenceAction());
		*/
		
		JMenuItem setDirectoryPath = new JMenuItem("Set Directory Path");
		setDirectoryPath.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				DirectorySettingWindow.getInstance().setVisible(true);
			}
		});
		
		this.add(setDirectoryPath);
		// ADD NorthGrid 2009/01/31
		JMenuItem setWebDavSetting = new JMenuItem("WebDAV Setting");
		setWebDavSetting.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				WebDavSetting webDavSetting = new WebDavSetting(WorkspaceWindow.getInstance(),true);
				webDavSetting.setLocationRelativeTo(null);
				webDavSetting.setVisible(true);
			}
		});
		this.add(setWebDavSetting);

		// ADD NorthGrid 2010/04/19
		JMenuItem setProxySetting = new JMenuItem("Proxy Setting");
		setProxySetting.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				ProxySetting proxySetting = new ProxySetting(WorkspaceWindow.getInstance(),true);
				proxySetting.setLocationRelativeTo(null);
				proxySetting.setVisible(true);
			}
		});
		this.add(setProxySetting);

		// ADD NorthGrid 2009/02/22
		JMenuItem setWebBrowser = new JMenuItem("Web Browser Setting");
		setWebBrowser.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				BrowserSettingDialog browserSettingDialog = new BrowserSettingDialog(WorkspaceWindow.getInstance());
				browserSettingDialog.setLocationRelativeTo(null);
				browserSettingDialog.setVisible(true);
			}
		});
		this.add(setWebBrowser);
		
		
		// ADD NorthGrid 2009/02/22
		JMenuItem setEditor = new JMenuItem("Editor Setting");
		setEditor.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				EditorSettingDialog editorSettingDialog = new EditorSettingDialog(WorkspaceWindow.getInstance());
				editorSettingDialog.setLocationRelativeTo(null);
				editorSettingDialog.setVisible(true);
			}
		});
		this.add(setEditor);
	}
}
