/* $Id: MemoPadRegion.java 144 2011-04-25 00:44:06Z minao $ */
package smart_gs.logical.region;

import java.awt.Color;
import java.awt.geom.Rectangle2D;


import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

public class MemoPadRegion extends Region{
	private boolean deleteArrowPointMode;
	
	public MemoPadRegion(Spread spread, Rectangle2D rectangle, String uri, String originalURI){
		super(spread, new MemoPadView(rectangle, MemoPadView.defaultMemoPadText),uri,originalURI);
	}

	public MemoPadRegion getRegion(Region region) {
		return (MemoPadRegion) region;
	}
	
	public String getMemoPadText() {
		return ((MemoPadView)this.view).getMemoPadText();
	}
	
	public void setMemoPadText(String text) {
		((MemoPadView)this.view).setMemoPadText(text);
	}
	
	public void setDeleteArrowPointMode(boolean b) {
		((MemoPadView)this.getView()).setDeleteArrowPointMode(b);
	}
}
