/* $Id: ImageFileFilter.java 147 2011-04-26 17:07:17Z minao $ */
package smart_gs.logical.filter;

import java.io.File;
import java.io.FilenameFilter;

public class ImageFileFilter implements FilenameFilter{
	public boolean accept(File dir, String name) {
		File file = new File(dir.getAbsolutePath()+"/"+name);
		if(name.endsWith("png") || name.endsWith("jpg") || name.endsWith("gif") || name.endsWith("JPG") || name.endsWith("JPEG")){
			return true;
		}
//		2011.1.17 shayashi added 2011.03.22 "dsc" added and make case-senseless.
		else if(name.startsWith(".")){
			return false;
		}
		else if(name.toUpperCase().equals("CVS")){
			return false;
		}
		else if(name.toUpperCase().equals("DSC")){
			return false;
		}
		else if(file.isDirectory()){
			return true;
		}
		return false;
	}
}