/* $Id: UsersNoteTree.java 147 2011-04-26 17:07:17Z minao $ */
package smart_gs.logical;

//20070923 shimizu wrote;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SuppressWarnings("serial")
public class UsersNoteTree extends JTree implements DragSourceListener,
		DropTargetListener, DragGestureListener {

	private static UsersNoteTree singleton = new UsersNoteTree();

	private UsersNote previousUsersNote; // OɍꂽXCh

	private List<UsersNote> usersNotes;

	private static final String NAME = "UsersNoteTree";

	private static final DataFlavor localObjectFlavor = new DataFlavor(
			DataFlavor.javaJVMLocalObjectMimeType, NAME);

	private static final DataFlavor[] supportedFlavors = { localObjectFlavor };

	protected DragSource dragSource;

	protected DropTarget dropTarget;

	TreeNode dropTargetNode = null;

	TreeNode draggedNode = null;

	TreePath dragsourceTreePath = null;

	private UsersNoteTree() {
		super(new DefaultMutableTreeNode("root"));
		this.usersNotes = new ArrayList<UsersNote>();

		setCellRenderer(new UsersNoteTreeCellRenderer());
		dragSource = new DragSource();
		dragSource.createDefaultDragGestureRecognizer(this,
				DnDConstants.ACTION_MOVE, this);
		dropTarget = new DropTarget(this, this);

	}

	public static UsersNoteTree getInstance() {
		return singleton;
	}

	public void addUsersNote(UsersNote usersNote) {
		this.usersNotes.add(usersNote);
		((DefaultMutableTreeNode) ((DefaultTreeModel) this.getModel())
				.getRoot()).add(new DefaultMutableTreeNode(usersNote));
		((DefaultTreeModel) this.getModel()).reload();

		this.previousUsersNote = usersNote;
	}

	public List<UsersNote> getUsersNotes() {
		return this.usersNotes;
	}

	public UsersNote getSelectedUsersNote() {
		TreePath path = this.getSelectionModel().getSelectionPath();
		if (path == null) {
			return null;
		}
		Object selectedObject = ((DefaultMutableTreeNode) path
				.getLastPathComponent()).getUserObject();
		if (selectedObject instanceof UsersNote) {
			return (UsersNote) selectedObject;
		}
		return null;
	}

	public void save(Document document, Element parent) {
		Element element = document.createElement("usersNoteTree");
		// 2011.01.03 change here to save usersNotes
		// as presentations
		for (int i = 0; i < this.usersNotes.size(); i++) {
			element.appendChild(this.usersNotes.get(i).createXMLElement(
					document));

		}
		parent.appendChild(element);
	}

	public void restore(Element usersNoteElement) {
		clear();

		NodeList elements = usersNoteElement
				.getElementsByTagName("usersNote");
		for (int i = 0; i < elements.getLength(); i++) {
			UsersNote usersNote = XML2ResourceConverter
					.getUsersNote((Element) elements.item(i));
			this.addUsersNote(usersNote);
		}
	}
	
	public void restorePresentations(Element usersNoteElement) {
		clear();

		NodeList elements = usersNoteElement
				.getElementsByTagName("presentation");
		for (int i = 0; i < elements.getLength(); i++) {
			UsersNote present = XML2ResourceConverter
					.getUsersNote((Element) elements.item(i));
			this.addUsersNote(present);
		}
	}
	
	public void reload(){
		((DefaultTreeModel) this.getModel()).reload();
	}
	
	public void clear() {
		this.usersNotes.clear();
		((DefaultMutableTreeNode) ((DefaultTreeModel) this.getModel())
				.getRoot()).removeAllChildren();
		((DefaultTreeModel) this.getModel()).reload();
	}

	public GSResource getUsersNoteByURI(String uri) {
		for (int i = 0; i < this.usersNotes.size(); i++) {
			System.out.print("HERE3!" + uri + this.usersNotes.get(i).getURI()+ "\n");
//			2011.02.17 shayashi changed
//			if (uri.startWith(this.usersNotes.get(i).getURI())) {
			// 2011/03/29 kukita changed
			if (extractUsersNoteURI(uri).equals(URICreator.getURIWithoutHeader(this.usersNotes.get(i)))
					|| uri.startsWith(this.usersNotes.get(i).getURI())) // for old version of uri
			{
				return this.usersNotes.get(i);
			}
//			2011.02.17 shayashi changed
//			if (uri.startsWith(this.usersNotes.get(i).getURI())) {
//				return this.usersNotes.get(i);
//			}
			// 1028 shimizu wrote;
			GSResource segment = this.usersNotes.get(i).getTextSegmentByURI(
					uri);
			if (segment != null) {
				return segment;
			}
		}
		return null;
	}
	
	private String extractUsersNoteURI(String uri) {
		String s = URICreator.SEP2 + URICreator.USERS_NOTE;
		return uri.substring(uri.indexOf(s)+1);
	}

	// ADD NorthGrid
	public void remove(){
		TreePath path = this.getSelectionModel().getSelectionPath();
		if (path == null) {
			return;
		}
		UsersNote deleteUsersNote = getSelectedUsersNote();
		if (deleteUsersNote == null) {
			return;
		}
		String nameStr = deleteUsersNote.toString();

		DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode) path.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();

        Enumeration enumeration = parentNode.children();
        int deletecount = 0;
        boolean deleteflg = false;
        while(enumeration.hasMoreElements()){
        	DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode)enumeration.nextElement();
        	String childrenStr = childrenNode.toString();
			if(childrenNode.getUserObject() instanceof UsersNote){
	        	if(childrenStr.equals(nameStr)){
	        		deleteflg = true;
	        		usersNotes.remove((UsersNote)childrenNode.getUserObject());
	        		break;
	        	}
			}
			deletecount++;
        }
        if(deleteflg){
        	parentNode.remove(deletecount);
        	this.updateUI();
        }else{
        	return;
        }
		// ēxlUȂ
		this.usersNotes.clear();
		enumeration = parentNode.children();
		int i = 0;
		while (enumeration.hasMoreElements()) {
			DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode) enumeration.nextElement();
			if (childrenNode.getUserObject() instanceof UsersNote) {
				UsersNote usersNote = (UsersNote) childrenNode
						.getUserObject();
				usersNote.setPageViewIndex(i);
				usersNotes.add(usersNote);
			}
			i++;
		}
        repaint();
        this.repaint();
	}
	
	// ADD NorthGrid ȉD&DCxg
	public void dragDropEnd(DragSourceDropEvent dsde) {
		dropTargetNode = null;
		draggedNode = null;
		dragsourceTreePath = null;
		// ĕ\
		repaint();
	}

	public void dragEnter(DragSourceDragEvent dsde) {
		dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
	}

	public void dragExit(DragSourceEvent dse) {
		dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
	}

	public void dragOver(DragSourceDragEvent dsde) {
	}

	public void dropActionChanged(DragSourceDragEvent dsde) {
	}

	public void dragEnter(DropTargetDragEvent dtde) {
		dtde.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);

	}

	public void dragExit(DropTargetEvent dte) {
	}

	public void dragOver(DropTargetDragEvent dtde) {
		DataFlavor[] f = dtde.getCurrentDataFlavors();
		boolean isDataFlavorSupported = f[0].getHumanPresentableName().equals(
				NAME);
		if (!isDataFlavorSupported) {
			// T|[gĂȂDataFlavorł(Ⴆ΃fXNgbvt@CȂ)
			rejectDrag(dtde);
			return;
		}
		Point pt = dtde.getLocation();
		TreePath path = getPathForLocation(pt.x, pt.y);
		if (path == null) {
			// m[hȊȌꏊł(ႦJTree̗]Ȃ)
			rejectDrag(dtde);
			return;
		}
		Object droppedObject;
		try {
			droppedObject = dtde.getTransferable().getTransferData(
					localObjectFlavor);
		} catch (Exception ex) {
			rejectDrag(dtde);
			return;
		}
		// ʃfBNgւ̈ړ͋֎~
		if (!path.getParentPath().toString().equals(
				dragsourceTreePath.getParentPath().toString())) {
			rejectDrag(dtde);
			return;
		}
		MutableTreeNode droppedNode = (MutableTreeNode) droppedObject;
		DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode) path
				.getLastPathComponent();
		DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode
				.getParent();
		while (parentNode != null) {
			if (droppedNode.equals(parentNode)) {
				// em[hqm[hɃhbv悤ƂĂ
				rejectDrag(dtde);
				return;
			}
			parentNode = (DefaultMutableTreeNode) parentNode.getParent();
		}
		dropTargetNode = targetNode;
		dtde.acceptDrag(dtde.getDropAction());
		repaint();
	}

	public void drop(DropTargetDropEvent dtde) {
		Object droppedObject;
		try {
			droppedObject = dtde.getTransferable().getTransferData(
					localObjectFlavor);
		} catch (Exception e) {
			e.printStackTrace();
			dtde.dropComplete(false);
			return;
		}
		DefaultTreeModel model = (DefaultTreeModel) getModel();
		Point p = dtde.getLocation();
		TreePath path = getPathForLocation(p.x, p.y);
		if (path == null || !(droppedObject instanceof MutableTreeNode)) {
			dtde.dropComplete(false);
			return;
		}
		MutableTreeNode droppedNode = (MutableTreeNode) droppedObject;
		DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode) path
				.getLastPathComponent();
		DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode
				.getParent();
		if (targetNode.equals(droppedNode)) {
			// ɂ̓hbvs
			dtde.dropComplete(false);
			return;
		}
		dtde.acceptDrop(DnDConstants.ACTION_MOVE);
		model.removeNodeFromParent(droppedNode);
		if (parentNode != null && targetNode.isLeaf()) {
			model.insertNodeInto(droppedNode, parentNode, parentNode
					.getIndex(targetNode));
		} else {
			model.insertNodeInto(droppedNode, targetNode, targetNode
					.getChildCount());
		}
		dtde.dropComplete(true);

		Enumeration enumeration = parentNode.children();
		// ԏmF
		int smallest = Integer.MAX_VALUE;
		while (enumeration.hasMoreElements()) {
			DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode) enumeration
					.nextElement();
			String childrenStr = childrenNode.toString();
			if (childrenNode.getUserObject() instanceof UsersNote) {
				if (childrenStr.indexOf(":") != -1) {
					String numberStr = childrenStr.substring(0, childrenStr
							.indexOf(":"));
					try {
						int number = Integer.parseInt(numberStr);
						if (smallest > number) {
							smallest = number;
						}
					} catch (NumberFormatException e) {
					}
				}
			}
		}
		// ēxlUȂ
		this.usersNotes.clear();
		enumeration = parentNode.children();
		int i = smallest;
		while (enumeration.hasMoreElements()) {
			DefaultMutableTreeNode childrenNode = (DefaultMutableTreeNode) enumeration
					.nextElement();
			String childrenStr = childrenNode.toString();
			if (childrenNode.getUserObject() instanceof UsersNote) {
				UsersNote usersNote = (UsersNote) childrenNode
						.getUserObject();
				usersNote.setPageViewIndex(i);
				usersNotes.add(usersNote);
			}
			i++;
		}
	}

	public void dropActionChanged(DropTargetDragEvent dtde) {
	}

	public void dragGestureRecognized(DragGestureEvent dge) {
		Point clickPoint = dge.getDragOrigin();
		TreePath path = getPathForLocation(clickPoint.x, clickPoint.y);
		if (path == null || path.getParentPath() == null) {
			return;
		}
		dragsourceTreePath = path;
		draggedNode = (TreeNode) path.getLastPathComponent();
		if (draggedNode instanceof DefaultMutableTreeNode) {
			if (((DefaultMutableTreeNode) draggedNode).getUserObject() instanceof UsersNote) {
				Transferable trans = new UsersNoteTreeTransferable(
						draggedNode);
				dragSource.startDrag(dge, Cursor.getDefaultCursor(), trans,
						this);
			}
		}
	}

	/**
	 * hbN̒~.
	 * 
	 * @param dtde
	 */
	private void rejectDrag(DropTargetDragEvent dtde) {
		dtde.rejectDrag();
		// dropTargetNode(flag)null
		dropTargetNode = null;
		// JTree`
		repaint();
	}

	/**
	 * 
	 * f[^ϊNX. AvȊÕhbN`FbN.
	 */
	class UsersNoteTreeTransferable implements Transferable {
		Object object;

		public UsersNoteTreeTransferable(Object o) {
			object = o;
		}

		// @Override
		public Object getTransferData(DataFlavor df)
				throws UnsupportedFlavorException, IOException {
			if (isDataFlavorSupported(df)) {
				return object;
			} else {
				throw new UnsupportedFlavorException(df);
			}
		}

		// @Override
		public boolean isDataFlavorSupported(DataFlavor df) {
			return (df.getHumanPresentableName().equals(NAME));
		}

		// @Override
		public DataFlavor[] getTransferDataFlavors() {
			return supportedFlavors;
		}
	}

	/**
	 * 
	 * RendererNX D&D̑Ctĕ\.
	 * 
	 */
	class UsersNoteTreeCellRenderer extends DefaultTreeCellRenderer {
		boolean isTargetNode;
		boolean isTargetNodeLeaf;
		boolean isLastItem;
		Insets normalInsets, lastItemInsets;
		int BOTTOM_PAD = 30;

		public UsersNoteTreeCellRenderer() {
			super();
			normalInsets = super.getInsets();
			lastItemInsets = new Insets(normalInsets.top, normalInsets.left,
					normalInsets.bottom + BOTTOM_PAD, normalInsets.right);
		}

		public Component getTreeCellRendererComponent(JTree tree, Object value,
				boolean isSelected, boolean isExpanded, boolean isLeaf,
				int row, boolean hasFocus) {
			isTargetNode = (value == dropTargetNode);
			isTargetNodeLeaf = (isTargetNode && ((TreeNode) value).isLeaf());
			// isLastItem = (index == list.getModel().getSize()-1);
			boolean showSelected = isSelected & (dropTargetNode == null);
			return super.getTreeCellRendererComponent(tree, value, isSelected,
					isExpanded, isLeaf, row, hasFocus);

		}

		public void paintComponent(Graphics g) {
			super.paintComponent(g);
			if (isTargetNode) {
				g.setColor(Color.black);
				if (isTargetNodeLeaf) {
					g.drawLine(0, 0, getSize().width, 0);
				} else {
					g.drawRect(0, 0, getSize().width - 1, getSize().height - 1);
				}
			}
		}
	}

}
