package smart_gs.logical;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import reasoning_web.logical.Connection;
import reasoning_web.logical.ExplanatoryNote;
import reasoning_web.logical.RWPackage;
import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.desktop.logical.ShortCut;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWPackage;

public class URICreator {
	private static final String ANONYMOUS_USER = URIObject.ANONYMOUS_USER;
	private static String LAST_CREATED_TIME;
	private static int ADDITIONAL_EXTENSION;

	public static final String HEADER = GSConstants.URI_HEADER;
	public static final String SEP1 = URIObject.SEP1;
	public static final String SEP2 = URIObject.SEP2;
	public static final String SEP3 = URIObject.SEP3;
	public static final String SEP4 = URIObject.SEP4;

	public static final String SPREAD_DIRECTORY = URIObject.SPREAD_DIRECTORY;
	public static final String SPREAD = URIObject.SPREAD;
	public static final String REGION = URIObject.REGION;
	public static final String LINE_SEGMENT = URIObject.LINE_SEGMENT;
	public static final String BOOKMARK = URIObject.BOOKMARK;
	public static final String POLYGON = URIObject.POLYGON;
	public static final String RECTANGLE = URIObject.RECTANGLE;
	public static final String MARKER = URIObject.MARKER;
	public static final String LINE = URIObject.LINE;
	public static final String MEMOPAD = URIObject.MEMOPAD;
	public static final String STANDARD_TEXT_DOCUMENT = URIObject.STANDARD_TEXT_DOCUMENT;
	public static final String IDAT = URIObject.IDAT;
	public static final String FIRST_IDAT = URIObject.FIRST_IDAT;
	public static final String SECOND_IDAT = URIObject.SECOND_IDAT;
	public static final String THIRD_IDAT = URIObject.THIRD_IDAT;
	public static final String USERS_NOTE = URIObject.USERS_NOTE;
	public static final String EXPLANATORY_NOTE = URIObject.EXPLANATORY_NOTE;
	public static final String TEXT_SEGMENT = URIObject.TEXT_SEGMENT;
	public static final String CONNECTION = URIObject.CONNECTION;
	public static final String RWPACKAGE = URIObject.RWPACKAGE;
	public static final String GS_RWPACKAGE = URIObject.GS_RWPACKAGE;
	public static final String GSQUERY = URIObject.GSQUERY;
	public static final String SHORTCUT = URIObject.SHORTCUT;
	public static final Object BACKET = URIObject.BACKET;
	public static final String DESKTOP_FOLDER = URIObject.DESKTOP_FOLDER;
	
	public static String createURI(RWElement elm) {
		String type = elm.getTypeString();
		String uri = "";
		if (type.equals(SPREAD_DIRECTORY)) {
			SpreadDirectory directory = (SpreadDirectory)elm;
			if (directory.getParent() == null) {
				uri = HEADER + type + SEP1 + "root" + SEP1;
			} else {
				uri = HEADER + getURIWithoutHeader(directory.getParent()) 
					+ modifyName(directory.getName()) + SEP1;
			}
		} else if (type.equals(SPREAD)) {
			Spread spread = (Spread)elm;
			String dir = spread.getVolume().createURI().substring(HEADER.length());
			String fileName = Spread.getFileNameWithoutExtension(spread.getFile());
			uri = HEADER + type + SEP1 + modifyName(fileName) + SEP1 + getURIExtension()
					+ SEP2 + dir;
		} else if (isARegion(type)) {
			Region region = (Region)elm;
			uri = HEADER + type + SEP1 + getURIExtension() + SEP2 
				+ getURIWithoutHeader(region.spread);
		} else if (isAnIDAT(type)) {
			IDAT idat = (IDAT)elm;
			uri = HEADER + type + SEP1 + getURIExtension() +SEP2
				+ getURIWithoutHeader(idat.spread); 
		} else if (type.equals(USERS_NOTE)) {
			UsersNote usersNote = (UsersNote)elm;
			uri = HEADER + type + SEP1 
				+ modifyName(usersNote.name) + SEP1 + getURIExtension() + SEP2
				+ "DIRECTORY" + SEP1;//TODO directory is to be added.
		} else if (type.equals(EXPLANATORY_NOTE)) {
			uri = HEADER + type + SEP1 + getURIExtension()
				+ SEP2; // extension is added after constructing related connection
		} else if (type.equals(TEXT_SEGMENT)) {
			TextSegment segment = (TextSegment)elm;
			uri = HEADER + type + SEP1 + getURIExtension();
			if (segment.getDocument() != null) {
				uri += SEP2 + getURIWithoutHeader(segment.getDocument());
			}
		} else if (type.equals(CONNECTION)) {
			Connection connection = (Connection)elm;
			String sourceURI = getURIWithoutHeader(connection.getSourceRWElement());
			String targetURI = getURIWithoutHeader(connection.getTargetRWElement());
			uri = HEADER + type + SEP1 + getURIExtension() 
				+ SEP3 + sourceURI
				+ SEP4 + targetURI;
		} else if (type.equals(STANDARD_TEXT_DOCUMENT)) {
			uri = HEADER + type + SEP1 + getURIExtension();
		} else if (type.equals(RWPACKAGE)) {
			RWPackage pack = (RWPackage)elm;
			uri = HEADER + type + SEP1 + modifyName(pack.getName()) + SEP1 
				+ getURIExtension();
		} else if (type.equals(GS_RWPACKAGE)) {
			GS_RWPackage pack = (GS_RWPackage)elm;
			uri = HEADER + type + SEP1 + modifyName(pack.getName()) + SEP1 
				+ getURIExtension();
		} else if (type.equals(GSQUERY)) {
			GSQuery query = (GSQuery)elm;
			String ext = "";
			if (query.hasSpread()) {
				ext = SEP2 + getURIWithoutHeader(query.getSpread());
			}
			uri = HEADER + type + SEP1 + modifyName(query.getName()) + SEP1
				+ getURIExtension() + ext;
		} else if (type.equals(SHORTCUT)) {
			ShortCut shortcut = (ShortCut)elm;
			uri = HEADER + type + SEP1 + getURIExtension() + SEP1
				+ SEP2 + getURIWithoutHeader(shortcut.getResource());
		} else {
			uri =  "unknown_uri";
		}
		return uri;
	}
	
	private static String getURIExtension(){
		String time  = createdTime();
		String add_ext = additionalExtension(time);
		LAST_CREATED_TIME = time;
		String name = Preference.getInstance().getUserName();
		if (name == null || name == "") {
			return ANONYMOUS_USER +SEP1+ time + add_ext + SEP1;
		} else {
			return modifyName(name) +SEP1+ time + add_ext + SEP1;
		}
	}
	private static String additionalExtension(String created_time) {
		String s = "";
		if (created_time.equals(LAST_CREATED_TIME)) {
			ADDITIONAL_EXTENSION++;
			s = "(" + Integer.toString(ADDITIONAL_EXTENSION) + ")";
		} else {
			ADDITIONAL_EXTENSION = 0;
		}
		return s;
	}
	private static String createdTime() {
		Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
		cal.setTime(new Date());
		String y = Integer.toString(cal.get(Calendar.YEAR));
		String m = adjust(cal.get(Calendar.MONTH) + 1);
		String d = adjust(cal.get(Calendar.DATE));
		String h = adjust(cal.get(Calendar.HOUR_OF_DAY));
		String min = adjust(cal.get(Calendar.MINUTE));
		String sec = adjust(cal.get(Calendar.SECOND));
		//String ms = cal.get(Calendar.MILLISECOND);
		return y + m + d + h + min + sec;
	}
	private static String adjust(int x) {
		if (x < 10) {
			return "0" + Integer.toString(x);
		} else {
			return Integer.toString(x);
		}
	}
	public static final String modifyName(String name) {
		if (name.equals("")) {
			return "UNNAMED";
		} else {
			return name.replace(" ", "?");
		}
	}
	public static final String getURIWithoutHeader(RWElement elm) {
		return elm.getURI().substring(HEADER.length());
	}
	public static Object getOriginalURIWithoutHeader(URIBearer ub) {
		return ub.getOriginalURI().substring(HEADER.length());
	}
	public static final boolean isARegion(String type) {
		return type.equals(RECTANGLE) ||
			type.equals(MARKER) ||
			type.equals(POLYGON) ||
			type.equals(MEMOPAD) ||
			type.equals(BOOKMARK) ||
			type.equals(LINE);
	}
	public static final boolean isAnIDAT(String type) {
		return type.equals(FIRST_IDAT) ||
			type.equals(SECOND_IDAT) ||
			type.equals(THIRD_IDAT);
	}
	
	public static void setURIs(URIBearer ub, String uri, String originalURI) {
		if (originalURI.equals("")) {
			ub.setOriginalURI(ub.createURI());
			ub.setURI(ub.getOriginalURI());
			if (!uri.equals("")) {
				ub.setOldVersionURI(uri);
			} else {
				ub.setOldVersionURI(GSConstants.URI_HEADER + GSConstants.URI_HEADER + "___________not_old_version______");
			}
		} else {
			ub.setOriginalURI(originalURI);
			ub.setURI(uri);
			ub.setOldVersionURI(GSConstants.URI_HEADER + GSConstants.URI_HEADER + "___________not_old_version______");
		}

	}

}