/* $Id: GSResource.java 182 2011-05-26 20:15:53Z minao $ */
package smart_gs.logical;


import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.logical.visitor.Acceptor;
import smart_gs.logical.visitor.CreateXMLElementVisitor;
import smart_gs.logical.visitor.ShowResourceVisitor;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;

public abstract class GSResource implements GS_RWElement,Acceptor,URIBearer{

	protected String uri;
	protected String originalURI;
	protected String oldVersionURI;
	protected String name;
	protected String version;
	protected int id;

	public static final String NAME = "name";
	public static final String ID = "id";
	public static final String URI = "uri";
	public static final String ORIGINAL_URI = "originalURI";
	public static final String VERSION = "version";
//	2011.03.29 shayashi deleted
//	//2007/11/20 kazuhiro kobayashi
//	protected String userName;
//	protected String systemName;
//
	public GSResource() {
		this.name = "";
		this.id = this.hashCode() % 1000;
		this.version = GSConstants.VERSION;
	}

	public void setId(int id) {
		this.id = id;
	}
	public int getId() {
		return id;
	}
	public String getURI(){
		return this.uri;
	}	
	public void setURI(String uri){
		this.uri = uri;
	}
	public void extendUriBy(String extension) {
		this.uri = this.uri + extension;
	}// 2011/01/19 kukita
	public void extendUriBy(int extension) {
		this.uri = this.uri + extension;
	}// 2011/01/19 kukita
	public String getName(){
		return this.name;
	}
	public void setName(String name){
		this.name = name;
	}

	public final void show() {
		ShowResourceVisitor visitor = new ShowResourceVisitor();
		this.accept(visitor);
	}
	public String getSource() throws NotMarkupException{
		throw new NotMarkupException();
	}
	public JPanel createElementViewPanel() throws NoWayToShowException {
		throw new NoWayToShowException();
	}
	@Override
	public String toString() {
		return this.uri;
		//		return this.name;
	}
	public final Element createXMLElement(Document document){
		CreateXMLElementVisitor visitor = new CreateXMLElementVisitor(document);
		this.accept(visitor);
		return visitor.getLastElement();
	}

	public abstract void accept(Visitor visitor);

//	2011.03.28 shayashi deleted
//	//2007/11/20 kazuhiro kobayashi
//	/**
//	 * Stringz󂯂āAsystemNamev̂userNameݒ肷B
//	 */
//	public void setUserName(String[] names){
//		if(names[0].equals(this.systemName)){
//			this.userName = names[1];
//		}
//	}

	public abstract String createURI();
	public abstract String getTypeString();



	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;
	}



	public String getOriginalURI() {
		return originalURI;
	}

	public void setURIs(String uri, String originalURI) {
		if (originalURI.equals("")) {
			this.originalURI = this.createURI();
			this.uri = this.originalURI;
			if (!uri.equals("")) {
				this.oldVersionURI = uri;
			} else {
				this.oldVersionURI = GSConstants.URI_HEADER + "___________not_old_version______";
			}
		} else {
			this.originalURI = originalURI;
			this.uri = uri;
			this.oldVersionURI = GSConstants.URI_HEADER + "___________not_old_version______";
		}
	}
	
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}
	
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;
	}
	@Override
	public void setVersion(String version) {
		this.version = version;
	}
	@Override
	public String getVersion() {
		return this.version;
	}
}
