/* $Id: ImageSearchPanel.java 144 2011-04-25 00:44:06Z minao $ */
package smart_gs.image_search.normal.swingui;


import image_editor.QueryImageEditor;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.commons.lang.StringUtils;

import smart_gs.dictionary.DictionaryXML;
import smart_gs.dictionary.image.ImageSearchFilterImpl;
import smart_gs.dictionary.image.ImageSearchFilterTypeAImpl;
import smart_gs.dictionary.image.ImageSearchFilterTypeBImpl;
import smart_gs.dictionary.image.ImageSearchFilterTypeCImpl;
import smart_gs.dictionary.viewer.SearchResultDictionaryViewer;
import smart_gs.image_search.SearchQueryAction;
import smart_gs.image_search.logical.GSQuery;
import smart_gs.image_search.logical.QueryBacket;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.LineSegment;
import smart_gs.logical.Preference;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;
import smart_gs.spread_selection.SetScopePanel;
import smart_gs.util.BmpFileCreator;
import smart_gs.util.ImageCropper;
import smart_gs.util.SegmentInfoCreator;

@SuppressWarnings("serial")
public class ImageSearchPanel extends JPanel {
	
	private Image image;
	private Region region;
	private File dscFile;
	private Rectangle rectangle = new Rectangle(0,0,100,50);
	private JLabel imageLabel;	
	/*
	 * spread̑Î߂ɒǉ
	 */
	private SetScopePanel scopePanel;
	
	private boolean isEdited = false;
	private int width = 100;
	private int height = 50;
	/*
	 * 菑T[`p
	 */
	public ImageSearchPanel(){
//		this.makeEditDialog();
		JLabel label = new JLabel("Select region before searching image.");
		this.add(label);
	}
	/*
	 * regionwT[`p
	 */
	public ImageSearchPanel(Region region) {
//		super(new JFrame(),"Search Dialog");
		this.setRegion(region);
		this.setRectangle(region);
		this.setDscFile();
		this.setImage(region);
		this.makeImageSearchDialog();
	}
	public void setRegion(Region region){
		this.region = region;
	}
	public void setRectangle(Region region){
		Rectangle2D rect = region.getView().getRectangle2D();
		this.rectangle = new Rectangle((int)rect.getX(),(int)rect.getY(),(int)rect.getWidth(),(int)rect.getHeight());
	}
	public void setDscFile(){
		this.dscFile = this.region.getSpread().getDscFile();
	}
	public void setImage(Region region){
		ImageCropper cropper = new ImageCropper(region);
		this.image = cropper.crop();
	}
	protected void makeImageSearchDialog(){
		this.setLayout(new BorderLayout());
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		JPanel imagePanel =this.createImagePanel();
		mainPanel.add(imagePanel,BorderLayout.CENTER);

		//kazuhiro kobayashi 10/4
		this.scopePanel = new SetScopePanel(true);	
		
		mainPanel.add(scopePanel,BorderLayout.SOUTH);
		
		JPanel buttonPanel = new JPanel();
		JButton ok = new JButton("Search");
		ok.addActionListener(new OKAction());
		buttonPanel.add(ok);
		
		JButton edit = new JButton("Edit");
		edit.addActionListener(new EditAction());
		buttonPanel.add(edit);
		
		JButton cancel = new JButton("Cancel");
		cancel.addActionListener(new CancelAction());
		buttonPanel.add(cancel);
		
		this.add(mainPanel,BorderLayout.CENTER);
		this.add(buttonPanel,BorderLayout.SOUTH);
//		this.setLocationRelativeTo(null);
//		this.pack();
	}
	
	protected JPanel createImagePanel(){
		JPanel imagePanel = new JPanel();
		this.imageLabel = new JLabel(new ImageIcon(this.image));
		imagePanel.add(this.imageLabel);
		imagePanel.setBorder(new TitledBorder("query image"));
		return imagePanel;
	}
	
	
	private void editSearch(){
		String folderPath = Spread.DSC_FOLDER_PATH;
		new BmpFileCreator(this.image,this.width,this.height).create(folderPath,"temp.bmp",false);
		List<LineSegment> segments = new ArrayList<LineSegment>();
		List<Point2D> points = new ArrayList<Point2D>();
		points.add(new Point(0,0));
		points.add(new Point(this.width-1,0));
		points.add(new Point(this.width-1,this.height-1));
		points.add(new Point(0,this.height-1));
		segments.add(new LineSegment(null,points,"",""));
		SegmentInfoCreator creator = new SegmentInfoCreator();
		creator.createSegmentInfo(segments, folderPath,"temp");
		File file = new File(folderPath+"temp.xml");
		creator.createDSCFile(file.getAbsolutePath(),false);
		GSQuery query = new GSQuery(this.image,new File(folderPath+"dsc/temp.dsc"),new Rectangle(0,0,width,height),"","");
		this.search(query);
		
	}

	private void search(GSQuery query){
//		List<Spread> spreads = this.getSpreadsToSearch();

		List<Spread> spreads = this.scopePanel.getSpreadsToSearch();
		List<Spread> spreadsToSearch = new ArrayList<Spread>();
		for(int i=0;i<spreads.size();i++){
			if(spreads.get(i).hasDscFile()){
				spreadsToSearch.add(spreads.get(i));
			}
		}
		
		SearchQueryAction searchAction = new SearchQueryAction(query,spreadsToSearch);
		// ̉摜̏ꍇ͂Őݒ肷.
		if(this.scopePanel.isImageDictionary()){
			String logic = Preference.getInstance().getInstance().getSearchImageDictionaryLogic();
			ImageSearchFilterImpl imageSearchFilterImpl;
			if(logic == null){
				logic = "0";
			}
			if(logic.equals("0")){
				imageSearchFilterImpl = new ImageSearchFilterTypeAImpl();
			}else if(logic.equals("1")){
				imageSearchFilterImpl = new ImageSearchFilterTypeBImpl();
			}else if(logic.equals("2")){
				imageSearchFilterImpl = new ImageSearchFilterTypeCImpl();
			}else{
				imageSearchFilterImpl = new ImageSearchFilterTypeAImpl();
			}
			imageSearchFilterImpl.init();
			searchAction.addImageSearchFilter(imageSearchFilterImpl);
		}
		searchAction.execute();
		List<SearchResult> results = searchAction.getResults();
		System.out.println("spread to search: " + spreads);
		System.out.println("showing...");
		List<GSQuery> queries = new ArrayList<GSQuery>();
		queries.add(query);
		
		QueryBacket backet = new QueryBacket("","",false);
		for(int i=0;i<queries.size();i++){
			backet.add(queries.get(i));
		}
		//2007/10/11 kazuhiro kobayashi 
		//Ώۂ̃y[W\邽
		if(this.scopePanel.isImageDictionary()){
			SearchResultDictionaryViewer searchResultDictionaryViewer = new SearchResultDictionaryViewer(backet,results, this.scopePanel.getSelectedPage());
			searchResultDictionaryViewer.setLocationRelativeTo(null);
			searchResultDictionaryViewer.setVisible(true);
		}else{
			new SearchResultViewer(backet,results, this.scopePanel.getSelectedPage()).setVisible(true);				
		}
//		dispose();
	}
	private class OKAction implements ActionListener{
		
		public void actionPerformed(ActionEvent e) {
			if(isEdited){
				editSearch();
				return;
			}
			
			GSQuery query = new GSQuery(region.getSpread(),dscFile,rectangle,"","");
			try{
				search(query);
			}catch(OutOfMemoryError err){
				JOptionPane.showMessageDialog(null,"Faild to search for memory shortage");
			}
		}
	}
	private void setImage(Image image,int width,int height){
		this.image = image;
		this.width = width;
		this.height = height;
		this.imageLabel.setIcon(new ImageIcon(image));
		this.repaint();
	}
	
	private class EditAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
			int width = (int)rectangle.getWidth();
			int height = (int)rectangle.getHeight();
			QueryImageEditor editor = new QueryImageEditor(ImageSearchPanel.this,image,width,height);
			editor.setVisible(true);
			if(editor.isEdited()){
				isEdited = true;
				setImage(editor.getImage(),width,height);
			}
			editor.dispose();
		}
	}
	/*
	 * ŏƂɎg
	 * 
	 */
	private void makeEditDialog(){
		
		int width = (int)rectangle.getWidth();
		int height = (int)rectangle.getHeight();
		
		
		QueryImageEditor editor = new QueryImageEditor(ImageSearchPanel.this,image,width,height);
		editor.setVisible(true);
		if(editor.isEdited()){
			isEdited = true;
			setImage(editor.getImage(),width,height);
		}
		editor.dispose();
	}
	private class CancelAction implements ActionListener{
		public void actionPerformed(ActionEvent e) {
//			dispose();
		}
	}
}
