/* $Id: QueryBacket.java 182 2011-05-26 20:15:53Z minao $ */
package smart_gs.image_search.logical;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import smart_gs.image_search.normal.swingui.BacketFrame;
import smart_gs.image_search.normal.swingui.Observer;
import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWPackage;
import smart_gs.reasoning_web.logical.XML2RWElementConverter;

public class QueryBacket extends GS_RWPackage{
	
	private List<Observer> observers;
	
	public QueryBacket(String uri, String originalURI, boolean restore){
		super(uri, originalURI, restore);
		this.observers = new ArrayList<Observer>();
	}
	
	public void add(GSQuery query){
		super.add(query);
		this.notifyChange();
	}
	
	public GSQuery get(int index){
		return (GSQuery)this.getElements().get(index);
	}
	
	public void remove(int index){
//		if(index >= 0 && index < this.size()){
//			return;
//		}
		//ύX@c
		if(index < 0 || index > this.size()){
			return;
		}
		this.getElements().remove(index);
		this.notifyChange();
	}

	public int size() {
		return this.getElements().size();
	}
	private void notifyChange(){
		for(int i=0;i<this.observers.size();i++){
			this.observers.get(i).update();
		}
	}
	public void addObserver(Observer panel) {
		this.observers.add(panel);
	}
	public void show(){
		new BacketFrame(this).setVisible(true);
	}
	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("backet");
		element.setAttribute("name",this.name);
		element.setAttribute("source",this.source);
		element.setAttribute("uri", this.uri);
		element.setAttribute(GSResource.ORIGINAL_URI, this.originalURI);
		element.setAttribute(GSResource.VERSION, this.version);
		for(int i=0;i<this.elements.size();i++){
			Element elem = ((GS_RWElement)this.elements.get(i)).createXMLElement(document);
			element.appendChild(elem);
		}
		return element;
	}
	public static QueryBacket restore(Element elem) {
		String name = elem.getAttribute("name");
		String source = elem.getAttribute("source");
		String uri = elem.getAttribute("uri");
		String originalURI = elem.getAttribute("originalURI");
		String version = elem.getAttribute(GSResource.VERSION);
		
		QueryBacket gsPackage = new QueryBacket(uri, originalURI, true);
		gsPackage.setName(name);
		gsPackage.setSource(source);
		
		NodeList children = elem.getChildNodes();
		for(int i=0;i<children.getLength();i++){
			Node node = children.item(i); 
			if(node.getNodeType() == Node.ELEMENT_NODE){
				GS_RWElement child = XML2RWElementConverter.convert((Element)node);
				gsPackage.add(child);
			}
		}
		if (version.equals("")) {
			gsPackage.setVersion("before 0.8");
		} else {
			gsPackage.setVersion(version);
		}

		return gsPackage;
	}
}
