/* $Id: GSQuery.java 182 2011-05-26 20:15:53Z minao $ */
package smart_gs.image_search.logical;

import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import reasoning_web.logical.NotMarkupException;
import reasoning_web.logical.inter_face.NoWayToShowException;
import smart_gs.GSConstants;
import smart_gs.logical.GSResource;
import smart_gs.logical.Spread;
import smart_gs.logical.URICreator;
import smart_gs.logical.URISolver;
import smart_gs.reasoning_web.URIBearer;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.smleditor.swingui.GSEditor;
import smart_gs.util.BmpFileCreator;

import image_search.Query;

public class GSQuery extends Query implements GS_RWElement,URIBearer{
	
	protected Spread spread = null;
	protected String name = "";
	private String uri;
	private String originalURI;
	private String oldVersionURI;
	private String version;
	
	public GSQuery(Spread spread,File dscFile, Rectangle rectangle) {
		super(spread.getImage(),dscFile, rectangle);
		this.spread = spread;
		this.version = GSConstants.VERSION;
//		this.setURIs(uri, originalURI);
	}

	public GSQuery(Image image,File dscFile,Rectangle rectangle){
		super(image,dscFile,rectangle);
		this.version = GSConstants.VERSION;
//		this.setURIs(uri, originalURI);
	}

	public GSQuery(Spread spread,Image image,File dscFile,Rectangle rectangle){
		super(image,dscFile,rectangle);
		this.spread = spread;
		this.version = GSConstants.VERSION;
//		this.setURIs(uri, originalURI);
	}

	public GSQuery(Spread spread, File dscFile, Rectangle rectangle,
			String uri, String originalURI) {
		this(spread,dscFile,rectangle);
		this.setName("UNNAMED");
		this.setURIs(uri, originalURI);
		this.version = GSConstants.VERSION;
	}

	public GSQuery(Image image, File file, Rectangle rectangle, String string,
			String string2) {
		this(image,file,rectangle);
		this.setName("UNNAMED");
		this.setURIs(uri, originalURI);
		this.version = GSConstants.VERSION;
	}

	public Spread getSpread(){
		return this.spread;
	}
	public boolean hasSpread(){
		if(this.spread == null){
			return false;
		}else{
			return true;
		}
	}
	public JPanel createElementViewPanel() throws NoWayToShowException {
		JLabel label = new JLabel(new ImageIcon(this.getQueryImage()));
		JPanel panel = new JPanel();
		panel.add(label);
		return panel;
	}
	public String getSource() throws NotMarkupException {
		//vC
		return "<xml><query/></xml>";
	}
	public void show() {
		if(this.spread != null){
			new GSEditor(this.spread,this.getRectangle()).setVisible(true);
		}else{
			JOptionPane.showMessageDialog(null,"can't jump to edited image");
		}
	}
	public String getName() {
		return this.name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Element createXMLElement(Document document) {
		Element element = document.createElement("query");
		element.setAttribute("hasSpread",this.hasSpread()+"");
		element.setAttribute("name",this.name);
		element.setAttribute(GSResource.URI, this.uri);
		element.setAttribute(GSResource.ORIGINAL_URI, this.originalURI);
		element.setAttribute(GSResource.VERSION, this.version);
		if( this.dscFile != null ){
			element.setAttribute("dscfile",this.dscFile.getAbsolutePath());
		}
		if(this.hasSpread()){
			element.setAttribute("spreadURI",this.spread.getURI());
		}else{
			//edited image̕ۑ
			BmpFileCreator creator = new BmpFileCreator(this.image,this.rectangle.width,this.rectangle.height);
			int id = this.hashCode();
			creator.create("temp/",id+".bmp",false);
			element.setAttribute("imagePath","temp/"+id+".bmp");
		}
		element.setAttribute("x",this.rectangle.x+"");
		element.setAttribute("y",this.rectangle.y+"");
		element.setAttribute("width",this.rectangle.width+"");
		element.setAttribute("height",this.rectangle.height+"");
		return element;
	}
	
	public GSQuery getQuery(Element element){
		boolean hasSpread = new Boolean(element.getAttribute("hasSpread"));
		String spreadURI = null;
		String name = element.getAttribute("name");
		if(hasSpread){
			spreadURI = element.getAttribute("spreadURI");
		}
		int x = new Integer(element.getAttribute("x"));
		int y = new Integer(element.getAttribute("y"));
		int width = new Integer(element.getAttribute("width"));
		int height = new Integer(element.getAttribute("height"));
		
		String uri = element.getAttribute("uri");
		String originalURI = element.getAttribute(GSResource.ORIGINAL_URI);
		String version = element.getAttribute(GSResource.VERSION);
		
		GSQuery query = null;
		if(hasSpread){
			Spread spread = (Spread)URISolver.getResource(spreadURI);
			query = new GSQuery(spread,spread.getDscFile(),new Rectangle(x,y,width,height));
			query.setName(name);
		}else{
			String dscFilePath = element.getAttribute("dscfile");
			String imagePath = element.getAttribute("imagePath");
			
			Image image = null;
			try {
				
				image = ImageIO.read(new File(imagePath));
				System.out.println("image :: "+image);
			} catch (IOException e) {
				e.printStackTrace();
			}
			
			File dscFile = new  File(dscFilePath);
			query = new GSQuery(image,dscFile,new Rectangle(x,y,width,height));
			query.setName(name);
		}
		query.setURIs(uri, originalURI);
		if (version.equals("")) {
			query.setVersion("before 0.8");
		} else {
			query.setVersion(version);
		}
		return query;
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	@Override
	public String getTypeString() {
		return URICreator.GSQUERY;
	}
	@Override
	public String getURI() {
		return this.uri;
	}
	public void setURI(String uri) {
		this.uri = uri;
	}
	@Override
	public String getOriginalURI() {
		return this.originalURI;
	}
	@Override
	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;		
	}
	@Override
	public void setURIs(String uri, String originalURI) {
		URICreator.setURIs(this, uri, originalURI);
	}

	@Override
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}

	@Override
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;
	}

	@Override
	public String getVersion() {
		return this.version;
	}

	@Override
	public void setVersion(String version) {
		this.version = version;
	}
}