/* $Id: BookmarkView.java 182 2011-05-26 20:15:53Z minao $ */
package smart_gs.drawing_tool.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import javax.swing.ImageIcon;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import smart_gs.GSConstants;
import smart_gs.logical.URICreator;


public class BookmarkView extends View {
	public static final int HUGE = 50;
	public static final int LARGE = 25;
	public static final int NORMAL = 0;
	public static final int SMALL = -25;
	public static final int TINY = -50;
	
	public static double DEFAULT_WIDTH = 60;
	public static double DEFAULT_HEIGHT = 56;
	public static int DEFAULT_SIZE = NORMAL;
	
	private Rectangle2D rectangle;
	private String title;
	private int size;
	
	public BookmarkView(Rectangle2D rectangle, String title, int size) {
		this.rectangle = rectangle;
		this.title = title;
		this.changeSize(size);
	}

	@Override
	public boolean contains(Point2D point) {
		int x = (int)this.rectangle.getX();
		int y = (int)this.rectangle.getY();
		int w = (int)(this.rectangle.getWidth() / 2);
		int h = (int)(this.rectangle.getHeight() / 2);
		Rectangle2D rect = new Rectangle2D.Double(x, y, w, h);
		return rect.contains(point);
	}

	@Override
	public Element createXMLElement(Document document) {
		Element element = document.createElement("view");
		element.setAttribute("type", URICreator.BOOKMARK);
		element.setAttribute("x",this.rectangle.getX()+"");
		element.setAttribute("y",this.rectangle.getY()+"");
		element.setAttribute("size",this.size+"");
		element.setAttribute("title",this.title);
		return element;
	}
	public static View restore(Element elem) {
		double x = new Double(elem.getAttribute("x"));
		double y = new Double(elem.getAttribute("y"));
		int size = new Integer(elem.getAttribute("size"));
		String title = elem.getAttribute("title");
		BookmarkView view = new BookmarkView(new Rectangle2D.Double(x, y, DEFAULT_WIDTH, DEFAULT_HEIGHT), title, size);
		view.size = size;
		return view;
	}

/*	@Override
	public void drawLinkedShape(Graphics2D g) {
		drawShape(g);
	}
*/
	@Override
	protected void drawShape(Graphics2D g) {
		String imageFileName;
		if (this.isSelected) {
			imageFileName = "bookmark_selected.png";
		} else {
			imageFileName = "bookmark.png";
		}
		ImageIcon imageIcon = new ImageIcon(
				GSConstants.ICON_PATH + imageFileName);
		Image image = imageIcon.getImage();
		int x = (int)this.rectangle.getX();
		int y = (int)this.rectangle.getY();
		int width = (int)this.rectangle.getWidth();
		int height = (int)this.rectangle.getHeight();
		g.drawImage(image, x, y, width, height, null);
		if (this.isProtected) {
			int xx = (int)this.rectangle.getX();
			int yy = (int)this.rectangle.getY();
			int ww = (int)(this.rectangle.getWidth() / 2);
			int hh = (int)(this.rectangle.getHeight());
			Rectangle rect = new Rectangle(xx, yy, ww, hh);
			g.setStroke(new BasicStroke(1));
			g.setColor(Color.BLACK);
			g.draw(rect);
		}
	}

	@Override
	public BookmarkView enlargedView(double ratio, double gapX, double gapY) {
		double x = this.rectangle.getX() * ratio + gapX;
		double y = this.rectangle.getY() * ratio + gapY;
		double w = this.rectangle.getWidth();
		double h = this.rectangle.getHeight();
		Rectangle2D newrect = new Rectangle2D.Double(x, y, w, h);
		BookmarkView view = new BookmarkView(newrect, this.title, this.size);
		view.setIsSelected(this.isSelected);
		view.isProtected = this.isProtected;
		return view;
	}

	@Override
	public Point getCenterPoint() {
		return new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
	}

	@Override
	public Rectangle2D getRectangle2D() {
		return this.rectangle;
	}

	@Override
	public int getType() {
		return View.BOOKMARK;
	}

	@Override
	public String getTypeString() {
		return URICreator.BOOKMARK;
	}

	@Override
	public void moveBy(Point2D d) {
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double w = this.rectangle.getWidth();
		double h = this.rectangle.getHeight();
		this.rectangle = new Rectangle2D.Double(x+d.getX(),y+d.getY(), w, h);
	}

	public String getTitle() {
		return this.title;
	}

	@Override
	public String getTypeStringForDisplay() {
		return "Bookmark";
	}
	public void changeSize(int size) {
		this.size = size;
		double x = this.rectangle.getX();
		double y = this.rectangle.getY();
		double w = DEFAULT_WIDTH * ((100 + size) / 100.0);
		double h = DEFAULT_HEIGHT * ((100 + size) / 100.0);
		this.rectangle = new Rectangle2D.Double(x, y, w, h);
	}

	public int getSize() {
		return this.size;
	}

}