/* $Id: BookmarkMode.java 182 2011-05-26 20:15:53Z minao $ */
package smart_gs.drawing_tool.drawing_mode;

import java.awt.geom.Rectangle2D;
import javax.swing.JOptionPane;
import smart_gs.drawing_tool.SpreadCanvas;
import smart_gs.drawing_tool.view.BookmarkView;
import smart_gs.logical.region.BookmarkRegion;
import smart_gs.swingui.GSMouseEvent;

public class BookmarkMode  extends DrawingModeAdapter {

	private static Mode singleton = new BookmarkMode();

	public static Mode getInstance() {
		return singleton;
	}
	
	@Override
	public void mouseClicked(GSMouseEvent e, SpreadCanvas canvas){
		String title = JOptionPane.showInputDialog("Title", "");
		if (title != null) {
			if (title.equals("")) {
				title = "No title";
			}
			double w = BookmarkView.DEFAULT_WIDTH;
			double h = BookmarkView.DEFAULT_HEIGHT;
			double x = e.getPoint().getX();
			double y = e.getPoint().getY();
			Rectangle2D rectangle = new Rectangle2D.Double(x, y, w, h);
			BookmarkView view = new BookmarkView(rectangle, title, BookmarkView.DEFAULT_SIZE);
			BookmarkRegion region = new BookmarkRegion(canvas.getSpread(), view,"","");
			canvas.addRegion(region);
		}
	}

}
