/* $Id: MemoPadChangeColorAction.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.drawing_tool.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import smart_gs.drawing_tool.view.MemoPadView;
import smart_gs.logical.Region;

public class MemoPadChangeColorAction implements ActionListener {
	MemoPadView view;
	MemoPadView.MemoPadColor color;
	
	public MemoPadChangeColorAction(Region region, MemoPadView.MemoPadColor color) {
		this.view = (MemoPadView)region.getView();
		this.color = color;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		switch(color) {
		case YELLOW:
			view.setColor(MemoPadView.MEMOPAD_YELLOW);
			return;
		case CYAN:
			view.setColor(MemoPadView.MEMOPAD_CYAN);
			return;
		case MAGENTA:
			view.setColor(MemoPadView.MEMOPAD_MAGENTA);
			return;
		case GREEN:
			view.setColor(MemoPadView.MEMOPAD_GREEN);
			return;
		case TRANSPARENT:
			view.transparentise();
			return;
		case OPAQUE:
			view.opaque();
			return;
		default:
			view.setColor(MemoPadView.MEMOPAD_YELLOW);
			return;
		}		
	}

}
