/* $Id: AbstractSearchResultPanel.java 125 2011-03-09 09:49:51Z ohura $ */
package smart_gs.dictionary.viewer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;

import smart_gs.dictionary.DictionaryXML;
import smart_gs.dictionary.image.SearchDictionaryResult;
import smart_gs.image_search.logical.SearchResult;
import smart_gs.logical.Region;
import smart_gs.logical.Spread;

@SuppressWarnings("serial")
public abstract class AbstractSearchResultPanel extends JPanel {
	
	protected List<SearchResult> results;
	
	protected List<JPanel> previousResults;
	protected List<JPanel> nextResults;
	protected List<JPanel> currentResults;
	
	protected int SIZE_TO_DISPLAY = 20;	
	protected int count = 0;
	protected int nextCount;
	protected boolean isFirst = true;
	
	protected Thread nextThread = null;
	
	protected SearchResultDictionaryViewer parent;
	
	protected Region region;
	
	public AbstractSearchResultPanel(SearchResultDictionaryViewer parent,List<SearchResult> results,Region region){
		this.parent = parent;
		this.results = results;
		this.previousResults = new ArrayList<JPanel>();
		this.nextResults = new ArrayList<JPanel>();
		this.currentResults = new ArrayList<JPanel>();
		this.region = region;
	}
	public void showResult(List<JPanel> list){
		this.removeAll();

		if(nextThread.isAlive()){
			try {
				nextThread.join();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		//ύX@c
//		int beginIndex = count*SIZE_TO_DISPLAY;
//		for(int i=beginIndex;i<beginIndex+SIZE_TO_DISPLAY && i < this.results.size();i++){
//			this.results.get(i).setWasShown(true);
//		}
		for(int i=0;i<list.size();i++){
			this.add(list.get(i));
		}
		this.currentResults.clear();
		this.currentResults.addAll(this.nextResults);
	}
	public void next(){
		this.count++;
		this.nextCount = this.count+1;
		this.showResult(this.nextResults);
		this.createNextResults(nextCount);
	}
	public void back(){
		this.count--;
		this.nextCount = this.count+1;
		if(nextThread.isAlive()){
			nextThread.interrupt();
		}
		this.createNextResults(count);
		this.showResult(this.nextResults);
		this.createNextResults(nextCount);
	}
	public synchronized void createNextResults(final int count){
		nextThread = new Thread(){
			@Override
			public void run() {
				super.run();

				int beginIndex = count*SIZE_TO_DISPLAY;
				nextResults.clear();
				for(int i=beginIndex;i<beginIndex+SIZE_TO_DISPLAY && i<results.size();i++){
					JPanel labelPanel = new JPanel();
					JPanel checkBoxPanel = new JPanel(new GridLayout(2,1));
					/*
					 * 20071109 c
					 * ₩O`FbNǉ
					 */
					/*
					ButtonGroup g = new ButtonGroup();
					JCheckBox checkBox = new JCheckBox("Yes");
					//checkBox = new ColleagueCheckBox("Yes", parent, results.get(i));
					JCheckBox removeBox = new JCheckBox("No");
					//removeBox = new ColleagueCheckBox("No", parent, results.get(i));
					JCheckBox suspendBox = new JCheckBox("Suspend");
					g.add(checkBox);
					g.add(removeBox);
					g.add(suspendBox);
					*/
					//createColleagues(i);
					
					String word = "";
					if(results.get(i) instanceof SearchDictionaryResult){
						word = ((SearchDictionaryResult)results.get(i)).getWord();
					}
					
					JLabel newLabel = new JLabel(word);
					/*
					if(results.get(i).isInBacket()){
						newLabel.setIcon(new ImageIcon("./icons/copy.gif"));
					}else if(!results.get(i).wasShown()){
						newLabel.setIcon(new ImageIcon("./icons/new.gif"));
					}
					*/
//					checkBox.addItemListener(new CheckAction(parent,results.get(i)));
					//checkBox.addItemListener(checkBox);
					// 20071109 c
//					removeBox.addItemListener(new RemoveAction(parent,results.get(i)));
					//removeBox.addItemListener(removeBox);
//					suspendBox.addItemListener(new SuspendAction(parent, results.get(i)));
					
					checkBoxPanel.add(newLabel);
					if(!word.equals("")){
						JButton button = new JButton();
						button.setText("register");
						button.addActionListener(new DictionaryRegister(word));
						checkBoxPanel.add(button);
					}
					// 20071109 c
//					checkBoxPanel.add(removeBox);
					//20080622 shimizu wrote
					//checkBoxPanel.add(suspendBox);
					
					labelPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
					labelPanel.add(checkBoxPanel);
					JLabel label = createImageLabel(results.get(i));
					
					Spread spread = results.get(i).getSpread();
					if(AbstractSearchResultPanel.this instanceof SearchResultListPanel){
						labelPanel.setBorder(new LineBorder(Color.BLACK));
					}else{
						labelPanel.setBorder(new TitledBorder(spread.getURI()));
					}
					labelPanel.add(label);					
		            nextResults.add(labelPanel);
					spread.release();
				}
			}
		};
		nextThread.start();
	}
	protected abstract JLabel createImageLabel(SearchResult result);

	public void updateBacket() {
		int beginIndex = count*SIZE_TO_DISPLAY;
		
		// 20071109 c
		// for(int i=0;i<SIZE_TO_DISPLAY;i++){
		for (int i = 0; i < SIZE_TO_DISPLAY - 1; i++) {
			JPanel panel = this.currentResults.get(i);
			JLabel label = (JLabel)((JPanel)panel.getComponent(0)).getComponent(0);
			if(this.results.get(beginIndex+i).isInBacket()){
				label.setIcon(new ImageIcon("./icons/copy.gif"));
			}
		}
		this.parent.validate();
		this.repaint();
		this.validate();
	}
	
	class DictionaryRegister implements ActionListener{
		protected String word;
		public DictionaryRegister(String word){
			this.word = word;
		}
		public void actionPerformed(ActionEvent e) {
			int value = JOptionPane.showConfirmDialog(parent , "Do you register?" ,"Confirm" , JOptionPane.YES_NO_OPTION);
			DictionaryXML dictionaryXML = DictionaryXML.getInstance();
			if (value == JOptionPane.YES_OPTION){
				dictionaryXML.add(word, region);
				try {
					dictionaryXML.write();
				} catch (ParserConfigurationException e1) {
					e1.printStackTrace();
				}
			}
		}
	}
}
