/* $Id: ConnectionCreator.java 144 2011-04-25 00:44:06Z minao $ */
/*
 * 쐬: 2006/06/02
 *
 */
package smart_gs.connection;

import java.awt.Frame;
import java.awt.Point;

import javax.swing.JOptionPane;

import reasoning_web.logical.Connection;
import smart_gs.logical.GSResource;
import smart_gs.reasoning_web.ExternalLinkDialog;
import smart_gs.reasoning_web.logical.GSExplanatoryNote;
import smart_gs.reasoning_web.logical.GS_RWElement;
import smart_gs.reasoning_web.logical.GS_RWRepository;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.swingui.toolbar.action.ShowLocalViewAction;
import smart_gs.util.HrefChecker;
import sml_editor.swingui.EditorTextPane;


/**
 * @author kazuaki kobayashi
 *
 * 
*/
public class ConnectionCreator {
	
	private static GS_RWElement source = null;
	
	public static void setSource(GS_RWElement source){
		ConnectionCreator.source = source;
		WorkspaceWindow.getInstance().setStatusBar(source.getURI());
	}
	public static void setTarget(GS_RWElement target){
		if(source == null){
			int answer = JOptionPane.showConfirmDialog(new Frame(), "link source doesn't exist","Information",JOptionPane.DEFAULT_OPTION);
			if (answer == JOptionPane.OK_OPTION) {
			}
			return;
		}
		
		GSExplanatoryNote note = new GSExplanatoryNote("<xml></xml>","","");
		// 2009/02/27 NorthGrid Delete
		/*
		ExplanatoryNoteDialog dialog = new ExplanatoryNoteDialog(note);
		dialog.setVisible(true);
		if(dialog.isCanceled()){
			ConnectionCreator.source = null;
			WorkspaceWindow.getInstance().setStatusBar("");
			return;
		}*/
		GS_RWRepository.getInstance().createConnection(source, target, note,Connection.TARGET_TO_SOURCE,"","",false);
		ConnectionCreator.source = null;
		WorkspaceWindow.getInstance().setStatusBar("");
		if(target instanceof GSResource){
			new ShowLocalViewAction((GSResource)target).execute();
		}
	}
	
	public static void setExternal(GS_RWElement target,EditorTextPane textPane,Point point){
		String urlStr = null;
		String checkURL = textPane.getSelectIDStr(point);
		int checkid = HrefChecker.check(checkURL);
		if(checkid == -1){
			urlStr = checkURL;
		}
		ExternalLinkDialog externalLinkDialog = new ExternalLinkDialog(WorkspaceWindow.getInstance(),urlStr);
		externalLinkDialog.setLocationRelativeTo(null);
		externalLinkDialog.setVisible(true);
		if(!externalLinkDialog.isCancel()){
			String registUrl = externalLinkDialog.getUrl();
			//textPane.changeID(point,registUrl.toLowerCase());
			//2011.01.04 shayashi when URL is all in lowercase,
			// Google books regards it as a machine generated ID
			// and refuses to connect.
			textPane.changeID(point,registUrl);
		}
	}
	
	public static boolean isSourceSet(){
		return source != null;
	}
	public static GS_RWElement getSource(){
		return source;
	}
}
