/* $Id: SmartGS.java 147 2011-04-26 17:07:17Z minao $ */
package smart_gs;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

import smart_gs.logical.Preference;
import smart_gs.swingui.WorkspaceWindow;

public class SmartGS {
	
	public static String[] arguments;
	
	public static void main(String[] args) {
		//20080118 North Grid Add
		
		ArrayList<String> temp = new ArrayList<String>();
		if( args.length > 0 ){
			for(int i = 0; i < args.length; i++){
				if( args[i].equals("-p") ){
					if( i < args.length-1 ){
						String preferenceFile = args[i+1];
						if(new File(preferenceFile).exists()){
							Preference.setPreferenceFile(preferenceFile);
							System.out.println("Loading from " + preferenceFile + ".");
						}else{
							System.out.println("can't find " + preferenceFile + ". Loading default...");
						}
					}else{
						System.out.println("Invalid parameter. Please set \"-p <preference file>\".  Loading default...");
					}
				}else{
					temp.add(args[i]);
				}
			}
		}
		
		String [] arguments = new String[temp.size()];
		for(int i = 0; i < temp.size(); i++){
			arguments[i] = temp.get(i);
		}

		SmartGS.arguments = new String[2];
		File fileCurrent=new File(".");

		if (arguments != null && arguments.length == 2) {
			SmartGS.arguments[0] = fileCurrent.getAbsolutePath() + "/" + arguments[0];
			SmartGS.arguments[1] = fileCurrent.getAbsolutePath() + "/" + arguments[1];
			System.out.println("DscSearch mode: exefile=\"" + arguments[0] + "\", assignlistfile=\"" + arguments[1] + "\"");
		}else{
			SmartGS.arguments[0] = fileCurrent.getAbsolutePath() + "/DscSearch.exe";
			SmartGS.arguments[1] = fileCurrent.getAbsolutePath() + "/temp/assignlist";
			System.out.println("DscSearch mode with using default path: exefile=\"" + SmartGS.arguments[0] + "\", assignlistfile=\"" + SmartGS.arguments[1] + "\"");
		}
		// ADD NorthGrid
		// OGfB^̃e|[t@C폜
		{
			File fileTemp=new File("./temp");
			if(!fileTemp.exists()){
				fileTemp.mkdirs();
				return;
			}
			// Õt@C폜
			File tempFiles[] = fileCurrent.listFiles();
			if(tempFiles != null){
				Calendar cal = Calendar.getInstance();
				cal.add(Calendar.DAY_OF_MONTH, -1);
				for(int i=0;i<tempFiles.length;i++){
					File file = tempFiles[i];
					if(file.getAbsolutePath().endsWith("html")){
						if(file.lastModified() < cal.getTime().getTime()){
							file.delete();
						}
					}
				}
			}
		}
		WorkspaceWindow.getInstance().setVisible(true);
		WorkspaceWindow.getInstance().setFileOpened(true);
	}
}
