/* $Id: DefaultFactory.java 144 2011-04-25 00:44:06Z minao $ */
package reasoning_web.logical;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.logical.URICreator;

public class DefaultFactory extends Factory{
	
	DefaultFactory(){
		
	}
	@Override
	public ExplanatoryNote createExplanatoryNote(String source, 
			String uri, String originalURI) {
		return new ExplanatoryNote(source,uri,originalURI);
	}
	@Override
	public Connection createConnection(ResourcePointer source,
			ResourcePointer target, ExplanatoryNote note, int dependency,
			String uri, String originalURI) {
		Connection connection =  new Connection(source,target,note,
				dependency,uri,originalURI);
		note.extendUriBy(URICreator.SEP2 + URICreator.getURIWithoutHeader(connection));
		return connection;
		
	}
	@Override
	public ResourcePointer createResourcePointer(RWElement element) {
		return new ResourcePointer(element);
	}
}
