/* $Id: Connection.java 182 2011-05-26 20:15:53Z minao $ */
package reasoning_web.logical;

import reasoning_web.logical.inter_face.RWElement;
import smart_gs.GSConstants;
import smart_gs.logical.URICreator;
import smart_gs.logical.URIObject;
import smart_gs.logical.visitor.Acceptor;
import smart_gs.logical.visitor.Visitor;
import smart_gs.reasoning_web.URIBearer;

public class Connection implements RWElement,URIBearer{
	
	protected ExplanatoryNote expNote;
	protected ResourcePointer source;
	protected ResourcePointer target;
	protected String name = "";
	protected String uri;
	protected String originalURI;
	protected String oldVersionURI;
	protected int dependency;
	protected String version;
	
	public static final int SOURCE_TO_TARGET = 0;   // sourcetargetɈˑ
	public static final int TARGET_TO_SOURCE = 1;   // targetsoruceɈˑ
	
	protected Connection(ResourcePointer source,ResourcePointer target,
			ExplanatoryNote note, int dependency,
			String uri, String originalURI) {
		this.source = source;
		this.target = target;
		this.source.addTarget(target);
		this.target.addSource(source);
		this.source.addConnection(this);
		this.target.addConnection(this);
		this.expNote = note;
		this.dependency = dependency;         //validȒl̃`FbN
		this.version = GSConstants.VERSION;
		this.setURIs(uri, originalURI);
		if (originalURI.equals("")) {
			note.extendUriBy(URIObject.getURIWithoutHeader(this));
		}
	}
	public void setName(String name){
		this.name = name;
	}
	public String getName(){
		return this.name;
	}
	public ExplanatoryNote getExplanatoryNote(){
		return this.expNote;
	}
	public ResourcePointer getSourcePointer(){
		return source;
	}
	public ResourcePointer getTargetPointer() {
		return target;
	}
	//20080521 shimizu localviewJƂɃN̎ނʂł悤ύXB;
	public ResourcePointer getOppositePointer(ResourcePointer pointer){
		if(pointer.equals(this.source)){
			this.target.position = 0;
			return this.target;
		}else if(pointer.equals(this.target)){
			this.source.position = 1;
			return this.source;
		}
		return null;
	}
	
	public String getSource() throws NotMarkupException {
		throw new NotMarkupException();
	}
	
	/**
	 * 
	 * @param pointer
	 * @return pointerˑĂvfԂ
	 */
	public ResourcePointer getDependentResource(ResourcePointer pointer){
		if(pointer.equals(this.source) && this.dependency == SOURCE_TO_TARGET){
			return this.target;
		}else if(pointer.equals(this.target) && this.dependency == TARGET_TO_SOURCE){
			return this.source;
		}
		return null;
	}
	
	/**
	 * 
	 * @param pointer
	 * @return pointerɈˑĂvfԂ
	 */
	public ResourcePointer getBackwardDependentResource(ResourcePointer pointer){
		if(pointer.equals(this.source) && this.dependency == TARGET_TO_SOURCE){
			return this.target;
		}else if(pointer.equals(this.target) && this.dependency == SOURCE_TO_TARGET){
			return this.source;
		}
		return null;
	}
	
	public void setURI(String uri) {
		this.uri = uri;
	}
	public String getURI() {
		return this.uri;
	}
	public String getURIWithoutExtension() {
		return this.uri.substring(GSConstants.URI_HEADER.length());
	}
	@Override
	public String createURI() {
		return URICreator.createURI(this);
	}
	public String getTypeString() {
		return URICreator.CONNECTION;
	}
	
	public RWElement getSourceRWElement() {
		return this.getSourcePointer().getElement();
	}
	public RWElement getTargetRWElement() {
		return this.getTargetPointer().getElement();
	}
	public String getOriginalURI() {
		return this.originalURI;
	}
	@Override
	public void setOriginalURI(String originalURI) {
		this.originalURI = originalURI;
	}
	@Override
	public void setURIs(String uri, String originalURI) {
		URICreator.setURIs(this, uri, originalURI);
	}
	@Override
	public String getOldVersionURI() {
		return this.oldVersionURI;
	}
	@Override
	public void setOldVersionURI(String oldVersionURI) {
		this.oldVersionURI = oldVersionURI;
	}
	@Override
	public String getVersion() {
		return this.version;
	}
	@Override
	public void setVersion(String version) {
		this.version = version;		
	}
}
