/* $Id: HrefValuedProperty.java 125 2011-03-09 09:49:51Z ohura $ */
/*
 * $Header$
 * $Revision: 207869 $
 * $Date: 2004-09-26 23:32:23 +0900 (日, 26  9月 2004) $
 *
 * ====================================================================
 *
 * Copyright 1999-2002 The Apache Software Foundation 
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.webdav.lib.properties;

import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.util.DOMUtils;
import org.w3c.dom.Element;

/**
 * Base classe for properties with a single <code>href</code> value.
 */
public class HrefValuedProperty extends BaseProperty {


    // -------------------------------------------------------------- Constants

    // ----------------------------------------------------------- Constructors

    /**
     * Default constructor for the property.
     */
    public HrefValuedProperty(ResponseEntity response, Element element) {
        super(response, element);
    }


    // --------------------------------------------------------- Public Methods

    /**
     * Returns the value of the href element.
     */
    public String getHref() {
        String hrefValue="";
        Element href = DOMUtils.getFirstElement(element, "DAV:", "href");
        if (href!=null)
        {
            hrefValue = DOMUtils.getTextValue(href);
        }
        return hrefValue;
    }

    public String getPropertyAsString() {
        return getHref();
    }

    public String toString() {
        return getHref();
    }

}
