/* $Id: DefaultMode.java 125 2011-03-09 09:49:51Z ohura $ */
package image_editor;

import image_editor.toolbar.PasteImageCommand;
import image_editor.toolbar.SelectedRectangleView;

import java.awt.Point;
import java.awt.event.MouseEvent;



public class DefaultMode extends Mode {
	
	private static Mode mode = new DefaultMode();
	
	private Point start = null;
	private Point end = null;
	
	
	private DefaultMode(){
		
	}
	
	public static Mode getInstance(){
		return mode;
	}

	@Override
	public void mouseClicked(MouseEvent e,EditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseDragged(MouseEvent e,EditorCanvas canvas) {
		this.end = e.getPoint();
		canvas.setSelection(new SelectedRectangleView(this.start,this.end));
	}

	@Override
	public void mouseEntered(MouseEvent e,EditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(MouseEvent e,EditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseMoved(MouseEvent e,EditorCanvas canvas) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent e,EditorCanvas canvas) {
		if(canvas.containsPastedImage(e.getPoint())){
			PasteImageCommand command = canvas.getPastedImage(e.getPoint());
			canvas.setMode(ImageSelectedMode.getInstance());
			((ImageSelectedMode)ImageSelectedMode.getInstance()).setCommand(command);
			return;
		}
		
		this.start = e.getPoint();
		canvas.setSelection(null);
	}

	@Override
	public void mouseReleased(MouseEvent e,EditorCanvas canvas) {
		if(this.start == null || this.end == null){
			this.start = null;
			this.end = null;
			return;
		}
		canvas.setSelection(new SelectedRectangleView(this.start,this.end));
		this.start = null;
		this.end = null;
	}
}
