package smart_gs.swingui.toolbar.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import smart_gs.image_search.logical.TextType;
import smart_gs.logical.GSResource;
import smart_gs.logical.LineSegmentForEdit;
import smart_gs.logical.Preference;
import smart_gs.logical.Spread;
import smart_gs.reasoning_web.swingui.action.SetRWBackgroundAction.ImageFileFilter;
import smart_gs.smleditor.swingui.LineSegEditor;
import smart_gs.swingui.AbstractGSWindow;
import smart_gs.swingui.WorkspaceWindow;
import smart_gs.util.CanonicalPathString;
import smart_gs.util.InConstruction;

public class ReadSegmentInfoAction implements ActionListener {
	private String file_contents;
	private LineSegEditor editor;
	private Spread spread;
	private String file_name;
	private List<LineSegmentForEdit> lines = null;
	private JFileChooser chooser;
	
	public ReadSegmentInfoAction(LineSegEditor parent) {
		this.editor = parent;
		this.spread = this.editor.getSpread();
		this.file_name = this.spread.getFileName();
		this.chooser = new JFileChooser(Preference.getInstance().getImageFolderPathString() + spread.getFolderPath());
	}
	
	@Override
	public void actionPerformed(ActionEvent arg0) {
		chooser.setMultiSelectionEnabled(false);
		chooser.setFileFilter(new SegfoFileFilter());
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		
		int input = chooser.showOpenDialog(WorkspaceWindow.getInstance());
		if (input == JFileChooser.CANCEL_OPTION) {
			return;
		}
		
		File file = chooser.getSelectedFile();
		
		String firstLineString;
		String secondLineString;
		
		StringBuffer bodyBufStr = new StringBuffer();
		try{
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String tmp_str;
            
            if ((firstLineString = br.readLine()) == null) {
                System.out.println("Someting wrong to read the first line of the file: " + file);
            	return;
            }
            
            if ((secondLineString = br.readLine()) == null) {
            	System.out.println("Someting wrong to read the second line of the file: " + file);
            	return;
            }
            
            while((tmp_str = br.readLine()) != null){
                bodyBufStr.append(tmp_str);
                bodyBufStr.append('\t');
            }
            br.close();
        }
        catch(IOException e){
            e.printStackTrace();
            System.out.println("Something wrong to read the file: " + file);
            return;
        }
        
        int start = firstLineString.indexOf(this.file_name);
        for (int i=0;i<start;i++) {
        	if (!Character.isWhitespace(firstLineString.indexOf(i))) {
        		JOptionPane.showMessageDialog(this.editor, String.format("1st line \"%s\" does not match the spread file name: \"%s\"",firstLineString,file_name));
        		return;
        	}
        }
        for (int i=start+this.file_name.length();i<firstLineString.length();i++) {
        	if (!Character.isWhitespace(firstLineString.indexOf(i))) {
        		JOptionPane.showMessageDialog(this.editor, String.format("1st line \"%s\" does not match the spread file name: \"%s\"",firstLineString,file_name));
        		return;
        	}
        }
		
        String directionInString = new String();
        if (Preference.getInstance().getTextType()==TextType.HORIZONTAL)
        	directionInString = "Horizontal";
        else 
        	directionInString = "Vertical";
		start = secondLineString.indexOf(directionInString);
        for (int i=0;i<start;i++) {
        	if (!Character.isWhitespace(secondLineString.indexOf(i))) {
        		JOptionPane.showMessageDialog(this.editor, String.format("2nd line \"%s\" does not match the current mode \"%s\"",secondLineString,directionInString));
        		return;
        	}
        }
        for (int i=start+directionInString.length();i<secondLineString.length();i++) {
        	if (!Character.isWhitespace(secondLineString.indexOf(i))) {
        		JOptionPane.showMessageDialog(this.editor, String.format("2nd line \"%s\" does not match the current mode \"%s\"",secondLineString,directionInString));
        		return;
        	}
        }
		
        file_contents = bodyBufStr.toString();
        String[] tokenArray = file_contents.split("[\\x20\\u0009\\u000D]+");
        List<Integer> intList = new ArrayList<Integer>();
        for (int i = 0;i<tokenArray.length;i++){
        	if (tokenArray[i].isEmpty()) i++;
        	try {
        		int tmpInt = Integer.parseInt(tokenArray[i]);
        		intList.add(tmpInt);
        	} catch (NumberFormatException e) {
        		JOptionPane.showMessageDialog(this.editor, String.format("%d-th element %d cannot be parsed as an integer",i,tokenArray[i]));
        		return;
        	}
        }
        
        if (intList.get(intList.size()-1)!=-99999) {
        	JOptionPane.showMessageDialog(this.editor, String.format("The last token should be -99999, but is %d",intList.get(intList.size())));
        }
        intList.remove(intList.size()-1);
        List<Point2D> tmpPointsList = new ArrayList<Point2D>();
        int size = intList.size();
        for (int i=0;i<size;i++) {
        	int tmpIntX = intList.get(i);
        	if (tmpIntX==-1){
        		if (tmpPointsList.isEmpty()) {
        			JOptionPane.showMessageDialog(this.editor, String.format("The line ends with %d-th element -1 is empty",i));
        			return;
        		}
        		if (lines == null) lines = new ArrayList<LineSegmentForEdit>();
        		lines.add(new LineSegmentForEdit(tmpPointsList));
        		tmpPointsList = new ArrayList<Point2D>();
        		continue;
        	}
        	if (tmpIntX<0) {
        		JOptionPane.showMessageDialog(this.editor, String.format("%d-th integer %d (x-axis) in the body is negative ",i,tmpIntX));
        	}
        	i++;
        	if (i>=size) {
        		JOptionPane.showMessageDialog(this.editor, String.format("The data did not end with -1"));
        		return;
        	}
        	int tmpIntY = intList.get(i);
        	if (tmpIntY<0) {
        		JOptionPane.showMessageDialog(this.editor, String.format("%d-th integer (y-axis) %d in the body is negative ",i,tmpIntX));
        	}
        	tmpPointsList.add((Point2D.Double)(new Point2D.Double((double)tmpIntX,(double)tmpIntY)));
        }
        editor.setLinesForEdit(lines);
        editor.rewriteLineSegIndexes();
        editor.repaint();
	}
}

